% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{num.arcsPE1D}
\alias{num.arcsPE1D}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs)
and related quantities of the induced subdigraphs for points in the partition intervals -
multiple interval case}
\usage{
num.arcsPE1D(Xp, Yp, r, c = 0.5)
}
\arguments{
\item{Xp}{A set or \code{vector} of 1D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set or \code{vector} of 1D points which constitute the end points of the partition intervals.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside the middle (partition) intervals
with the default \code{c=.5}.
For an interval, \eqn{(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
A \code{list} with the elements
\item{desc}{A short description of the output: number of arcs
and related quantities for the induced subdigraphs in the partition intervals}
\item{num.arcs}{Total number of arcs in all intervals (including the end intervals),
i.e., the number of arcs for the entire PE-PCD}
\item{num.in.range}{Number of \code{Xp} points in the range or convex hull of \code{Yp} points}
\item{num.in.ints}{The vector of number of \code{Xp} points in the partition intervals (including the end intervals)
based on \code{Yp} points}
\item{weight.vec}{The \code{vector} of the lengths of the middle partition intervals (i.e., end intervals excluded)
based on \code{Yp} points}
\item{int.num.arcs}{The \code{vector} of the number of arcs of the components of the PE-PCD in the
partition intervals (including the end intervals) based on \code{Yp} points}
\item{part.int}{A matrix with columns corresponding to the partition intervals based on \code{Yp} points.}
\item{data.int.ind}{A \code{vector} of indices of partition intervals in which data points reside,
i.e., column number of \code{part.int} is provided for each \code{Xp} point. Partition intervals are numbered from left to right
with 1 being the left end interval.}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the partition intervals based on \code{Yp} points.}
\item{vertices}{Vertices of the digraph, \code{Xp}.}
}
\description{
An object of class \code{"NumArcs"}.
Returns the number of arcs and various other quantities related to the partition intervals
for Proportional Edge Proximity Catch Digraph
(PE-PCD) whose vertices are the data points in \code{Xp}
in the multiple interval case.

For this function, PE proximity regions are constructed data points inside or outside the intervals based
on \code{Yp} points with expansion parameter \eqn{r \ge 1} and centrality parameter \eqn{c \in (0,1)}. That is, for this function,
arcs may exist for points in the middle or end intervals.

Range (or convex hull) of \code{Yp} (i.e., the interval \eqn{(\min(Yp),\max(Yp))}) is partitioned by the spacings based on
\code{Yp} points (i.e., multiple intervals are these partition intervals based on the order statistics of \code{Yp} points
whose union constitutes the range of \code{Yp} points). For the number of arcs, loops are not counted.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\dontrun{
r<-2
c<-.4
a<-0; b<-10; int<-c(a,b);

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-15; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xf<-(int[2]-int[1])*.1

Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)

Narcs = num.arcsPE1D(Xp,Yp,r,c)
Narcs
summary(Narcs)
plot(Narcs)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.arcsPEint}}, \code{\link{num.arcsPEmid.int}}, \code{\link{num.arcsPEend.int}},
and \code{\link{num.arcsCS1D}}
}
\author{
Elvan Ceyhan
}
