% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{interval.indices.set}
\alias{interval.indices.set}
\title{Indices of the intervals where the 1D point(s) reside}
\usage{
interval.indices.set(Xp, Yp)
}
\arguments{
\item{Xp}{A set of 1D points for which the indices of intervals are to be determined.}

\item{Yp}{A set of 1D points from which intervals are constructed.}
}
\value{
The \code{vector} of indices of the intervals in which points in the 1D data set, \code{Xp}, reside
}
\description{
Returns the indices of intervals for all the points in 1D data set, \code{Xp}, as a vector.

Intervals are based on \code{Yp} and left end interval is labeled as 1, the next interval as 2, and so on.
}
\examples{
\dontrun{
a<-0; b<-10; int<-c(a,b)

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-15; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xf<-(int[2]-int[1])*.1
Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)  #try also Yp<-runif(ny,a+1,b-1)

ind<-interval.indices.set(Xp,Yp)
ind

jit<-.1
yjit<-runif(nx,-jit,jit)

Xlim<-range(a,b,Xp,Yp)
xd<-Xlim[2]-Xlim[1]

plot(cbind(a,0), xlab=" ", ylab=" ",xlim=Xlim+xd*c(-.05,.05),ylim=3*c(-jit,jit),pch=".")
abline(h=0)
points(Xp, yjit,pch=".",cex=3)
abline(v=Yp,lty=2)
text(Xp,yjit,labels=factor(ind))
}

}
\author{
Elvan Ceyhan
}
