% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{NPEtetra}
\alias{NPEtetra}
\title{The vertices of the Proportional Edge (PE) Proximity Region in a tetrahedron}
\usage{
NPEtetra(p, th, r, M = "CM", rv = NULL)
}
\arguments{
\item{p}{A 3D point whose PE proximity region is to be computed.}

\item{th}{A \eqn{4 \times 3} matrix with each row representing a vertex of the tetrahedron.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes \code{"CC"} for circumcenter and \code{"CM"} for center of mass; default=\code{"CM"}.}

\item{rv}{Index of the vertex region containing the point, either \code{1,2,3,4} (default is \code{NULL}).}
}
\value{
Vertices of the tetrahedron which constitutes the PE proximity region with expansion parameter
\code{r} and circumcenter (or center of mass) for a point \code{p} in the tetrahedron
}
\description{
Returns the vertices of the PE proximity region (which is itself a tetrahedron) for a point in the
tetrahedron \code{th}.

PE proximity region is defined with respect to the tetrahedron \code{th}
with expansion parameter \eqn{r \ge 1} and vertex regions based on the center \code{M} which is circumcenter (\code{"CC"}) or
center of mass (\code{"CM"}) of \code{th} with default=\code{"CM"}.

Vertex regions are labeled as \code{1,2,3,4} rowwise for the vertices of the tetrahedron \code{th}.
\code{rv} is the index of the vertex region \code{p} resides, with default=\code{NULL}.
If \code{p} is outside of \code{th}, it returns \code{NULL} for the proximity region.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
set.seed(1)
tetra<-rbind(A,B,C,D)+matrix(runif(12,-.25,.25),ncol=3)
n<-3  #try also n<-20

Xp<-runif.tetra(n,tetra)$g

M<-"CM"  #try also M<-"CC"
r<-1.5

NPEtetra(Xp[1,],tetra,r)  #uses the default M="CM"
NPEtetra(Xp[1,],tetra,r,M="CC")

#or try
RV<-rel.vert.tetraCM(Xp[1,],tetra)$rv
NPEtetra(Xp[1,],tetra,r,M,rv=RV)

P1<-c(.1,.1,.1)
NPEtetra(P1,tetra,r,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NPEstd.tetra}}, \code{\link{NPEtri}} and \code{\link{NPEint}}
}
\author{
Elvan Ceyhan
}
