% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{NumArcsCS1D}
\alias{NumArcsCS1D}
\title{Number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) for 1D data - multiple interval case}
\usage{
NumArcsCS1D(Xp, Yp, t, c = 0.5)
}
\arguments{
\item{Xp}{A set or \code{vector} of 1D points which constitute the vertices of the CS-PCD.}

\item{Yp}{A set or \code{vector} of 1D points which constitute the end points of the partition intervals.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region;
must be \eqn{> 0}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside the middle (partition) intervals
with the default \code{c=.5}.
For an interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
A \code{list} with the elements
\item{num.arcs}{Total number of arcs in all intervals (including the end intervals),
i.e., the number of arcs for the entire CS-PCD}
\item{num.in.range}{Number of \code{Xp} points in the range or convex hull of \code{Yp} points}
\item{num.in.ints}{The vector of number of \code{Xp} points in the partition intervals (including the end intervals)
based on \code{Yp} points}
\item{weight.vec}{The \code{vector} of the lengths of the middle partition intervals (i.e., end intervals excluded)
based on \code{Yp} points}
\item{int.num.arcs}{The \code{vector} of the number of arcs of the component of the CS-PCD in the
partition intervals (including the end intervals) based on \code{Yp} points}
\item{part.int}{A list of partition intervals based on \code{Yp} points.}
\item{data.int.ind}{A \code{vector} of indices of partition intervals in which data points reside,
i.e., column number of \code{part.int} is provided for each \code{Xp} point. Partition intervals are numbered from left to right
with 1 being the left end interval.}
}
\description{
Returns the number of arcs of Central Similarity Proximity Catch Digraph (CS-PCD) whose vertices are
the data points in \code{Xp} in the multiple interval case.

For this function, CS proximity regions are constructed data points inside or outside the intervals based
on \code{Yp} points with expansion parameter \eqn{t \ge 0} and centrality parameter \eqn{c \in (0,1)}. That is, for this function,
arcs may exist for points in the middle or end intervals.

Range (or convex hull) of \code{Yp} (i.e., the interval \eqn{(\min(Yp),\max(Yp))}) is partitioned by the spacings based on
\code{Yp} points (i.e., multiple intervals are these partition intervals based on the order statistics of \code{Yp} points
whose union constitutes the range of \code{Yp} points). For the number of arcs, loops are not counted.
}
\examples{
\dontrun{
tau<-1.5
c<-.4
a<-0; b<-10; int<-c(a,b);

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xf<-(int[2]-int[1])*.1

Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)

NumArcsCS1D(Xp,Yp,tau,c)
NumArcsCS1D(Xp,Yp,tau,c=.3)
NumArcsCS1D(Xp,Yp,t=2,c)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsCSint}}, \code{\link{NumArcsCSmid.int}}, \code{\link{NumArcsCSend.int}}, and \code{\link{NumArcsPE1D}}
}
\author{
Elvan Ceyhan
}
