% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{radius}
\alias{radius}
\title{The radius of a point from one class with respect to points from the other class}
\usage{
radius(pt, Y)
}
\arguments{
\item{pt}{A \eqn{d}-dimensional point for which radius is computed. Radius of \code{pt} equals to the
distance to the closest \code{Y} point to \code{pt}.}

\item{Y}{A set of \eqn{d}-dimensional points representing the reference points for the balls. That is, radius
of the point \code{pt} is defined as the minimum distance to the \code{Y} points.}
}
\value{
A \code{list} with three elements
\item{rad}{Radius value for the point, \code{pt} defined as \eqn{\min_{y in Y} d(pt,y)}}
\item{index.of.clYpnt}{Index of the closest \code{Y} points to the point \code{pt}}
\item{closest.Ypnt}{The closest \code{Y} point to the point \code{pt}}
}
\description{
Returns the radius for the ball centered at point \code{pt} with radius=min distance to \code{Y} points.
That is, for the point \code{pt} \eqn{radius= \min_{y \in Y}d(pt,y)} (i.e., distance from \code{pt} to the closest \code{Y} point).
The point \code{pt} and \code{Y} points must be of same dimension.
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);

ny<-10
Y<-cbind(runif(ny),runif(ny))
radius(A,Y)
radius(B,Y)
radius(C,Y)

radius(B,C)

nx<-10
X<-cbind(runif(nx),runif(nx))
rad<-rep(0,nx)
for (i in 1:nx)
rad[i]<-radius(X[i,],Y)$rad

Xlim<-range(X[,1]-rad,X[,1]+rad,Y[,1])
Ylim<-range(X[,2]-rad,X[,2]+rad,Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(rbind(Y),asp=1,pch=16,col=2,xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(rbind(X))
interp::circles(X[,1],X[,2],rad,lty=1,lwd=1,col=4)

dat.fr<-data.frame(a=Y)
radii(A,dat.fr)

}
\seealso{
\code{\link{radii}}
}
\author{
Elvan Ceyhan
}
