% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndNCStriSet}
\alias{IndNCStriSet}
\title{The indicator for the presence of an arc from a point in set \code{S} to the point \code{pt} for
Central Similarity Proximity Catch Digraphs (CS-PCDs) - one triangle case}
\usage{
IndNCStriSet(S, pt, tau, tri, M = c(1, 1, 1))
}
\arguments{
\item{S}{A set of 2D points. Presence of an arc from a point in \code{S} to point \code{pt} is checked
by the function.}

\item{pt}{A 2D point. Presence of an arc from a point in \code{S} to point \code{pt} is checked
by the function.}

\item{tau}{A positive real number which serves as the expansion parameter in CS proximity region
constructed in the triangle \code{tri}.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.}
}
\value{
I(\code{pt} is in \eqn{\cup_{x in S} N_{CS}(x,\tau)}), that is, returns 1 if \code{pt} is in \code{S} or inside \eqn{N_{CS}(x,\tau)} for at least
one \eqn{x} in \code{S}, returns 0 otherwise where CS proximity region is constructed with respect to the triangle \code{tri}
}
\description{
Returns I(\code{pt} in \eqn{N_{CS}(x,\tau)} for some \eqn{x} in \code{S}), that is, returns 1 if \code{pt} in \eqn{\cup_{x in S} N_{CS}(x,\tau)},
returns 0 otherwise.

CS proximity region is constructed with respect to the triangle \code{tri} with
the expansion parameter \eqn{t>0} and edge regions are based on the center, \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.

Edges of \code{tri}\eqn{=T(A,B,C)}, \eqn{AB}, \eqn{BC}, \eqn{AC}, are also labeled as edges 3, 1, and 2, respectively.
If \code{pt} is not in \code{S} and either \code{pt} or all points in \code{S} are outside \code{tri}, it returns 0,
but if \code{pt} is in \code{S}, then it always returns 1 regardless of its location (i.e., loops are allowed).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runif.tri(n,Tr)$gen.points

S<-rbind(dat[1,],dat[2,])  #try also S<-c(1.5,1)

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

tau<-.5

IndNCStriSet(S,dat[3,],tau,Tr,M)
IndNCStriSet(S,dat[3,],tau=1,Tr,M)
IndNCStriSet(S,dat[3,],tau=1.5,Tr,M)

S<-rbind(dat[1,],dat[2,],dat[3,],dat[5,])
IndNCStriSet(S,dat[3,],tau,Tr,M)

IndNCStriSet(S,dat[6,],tau,Tr,M)
IndNCStriSet(S,dat[6,],tau=.25,Tr,M)

S<-rbind(c(.1,.1),c(.3,.4),c(.5,.3))
IndNCStriSet(S,dat[3,],tau,Tr,M)

IndNCStriSet(c(.2,.5),dat[2,],tau,Tr,M)
IndNCStriSet(dat,c(.2,.5),tau,Tr,M)
IndNCStriSet(dat,dat[2,],tau,Tr,M)
IndNCStriSet(c(.2,.5),c(.2,.5),tau,Tr,M)
IndNCStriSet(dat[5,],dat[2,],tau,Tr,M)

S<-rbind(dat[1,],dat[2,],dat[3,],dat[5,],c(.2,.5))
IndNCStriSet(S,dat[3,],tau,Tr,M)

P<-c(.4,.2)
S<-dat[c(1,3,4),]
IndNCStriSet(dat,P,tau,Tr,M)

IndNCStriSet(rbind(S,S),P,tau,Tr,M)

dat.fr<-data.frame(a=S)
IndNCStriSet(dat.fr,P,tau,Tr,M)

}
\seealso{
\code{\link{IndCSTeSet}}, \code{\link{IndNCStri}}, \code{\link{IndCSTe}}, \code{\link{IndNAStriSet}}, and \code{\link{IndNPEtriSet}}
}
\author{
Elvan Ceyhan
}
