% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{summary.Planes}
\alias{summary.Planes}
\title{Return a summary of a \code{Planes} object}
\usage{
\method{summary}{Planes}(object, ...)
}
\arguments{
\item{object}{Object of class \code{Planes}.}

\item{\dots}{Additional parameters for \code{summary}.}
}
\value{
The \code{call} of the object of class '\code{Planes}',
the defining 3D \code{points}, selected x, y and z points on the plane,
equation of the plane, and \code{coefficients} of the plane (in the form: z = A*x + B*y + C).
}
\description{
Returns the below information about the \code{object}:

\code{call} of the function defining the \code{object}, the defining 3D \code{points}, selected x, y and z points on
the plane, equation of the plane, and \code{coefficients} of the plane.
}
\examples{
A<-c(1,10,3); B<-c(1,1,3); C<-c(3,9,12)
pts<-rbind(A,B,C)

xr<-range(pts[,1]); yr<-range(pts[,2])
xf<-(xr[2]-xr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
yf<-(yr[2]-yr[1])*.1 #how far to go at the lower and upper ends in the y-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=100)
y<-seq(yr[1]-yf,yr[2]+yf,l=100)

plABC<-Plane(A,B,C,x,y)
plABC
summary(plABC)

}
\seealso{
\code{\link{print.Planes}}, \code{\link{print.summary.Planes}}, and \code{\link{plot.Planes}}
}
