% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{rverts.tri.nd}
\alias{rverts.tri.nd}
\title{The indices of the vertex regions in a triangle that contains the points in a give data set}
\usage{
rverts.tri.nd(Dt, tri, r, cent = 1)
}
\arguments{
\item{Dt}{A set of 2D points representing the set of data points for which indices of the vertex regions
containing them are to be determined.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be in \eqn{(1,1.5]} for this function.}

\item{cent}{Index of the center (as 1,2,3 corresponding to M1,M2,M3) which gives nondegenerate asymptotic
distribution of the domination number of PE-PCD for uniform data in \code{tri} for expansion parameter \code{r} in \eqn{(1,1.5]};
default \code{cent}=1.}
}
\value{
A list with two elements
\item{rv}{Indices (i.e., a vector of indices) of the vertices whose region contains points in \code{Dt}
in the triangle \code{tri}}
\item{tri}{The vertices of the triangle, where row number corresponds to the vertex index in \code{rv}.}
}
\description{
Returns the indices of the vertices whose regions contain the points in data set \code{Dt} in
a triangle \code{tri}=\eqn{(A,B,C)} and vertex regions are based on the center \code{cent} which yields nondegenerate asymptotic
distribution of the domination number of PE-PCD for uniform data in \code{tri} for expansion parameter \code{r} in \eqn{(1,1.5]}.

Vertices of triangle \code{tri} are labeled as 1,2,3 according to the row number the vertex is recorded
if a point in \code{Dt} is not inside \code{tri}, then the function yields \code{NA} as output for that entry.
The corresponding vertex region is the polygon with the vertex, \code{cent}, and projection points on the edges.
The center label \code{cent} values 1,2,3 correspond to the vertices \eqn{M_1}, \eqn{M_2}, and \eqn{M_3}; with default 1
(see the examples for an illustration).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:dom-num-NPE-Spat2011,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
r<-1.35
cent<-2

P<-c(1.4,1.0)
rverts.tri.nd(P,Tr,r,cent)

P<-c(1.8,.5)
rverts.tri.nd(P,Tr,r,cent)

P<-c(10.5,1.6)
rverts.tri.nd(P,Tr,r,cent)

n<-10  #try also n<-20
set.seed(1)
dat<-runif.tri(n,Tr)$g

rverts.tri.nd(dat,Tr,r,cent)
rverts.tri.nd(rbind(dat,c(2,2)),Tr,r,cent)

rv<-rverts.tri.nd(dat,Tr,r,cent)

M<-cent.nondeg(Tr,r)[cent,];
Ds<-cp2edges.nd(Tr,r,cent)

Xlim<-range(Tr[,1],dat[,1])
Ylim<-range(Tr[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(dat,pch=".",col=1)
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

xc<-Tr[,1]+c(-.03,.05,.05)
yc<-Tr[,2]+c(-.06,.02,.05)
txt.str<-c("rv=1","rv=2","rv=3")
text(xc,yc,txt.str)

txt<-rbind(M,Ds)
xc<-txt[,1]+c(.02,.04,-.03,0)
yc<-txt[,2]+c(.07,.03,.05,-.07)
txt.str<-c("M","D1","D2","D3")
text(xc,yc,txt.str)

text(dat,labels=factor(rv$rv))

P<-c(1.4,1.0)
rverts.tri.nd(P,Tr,r,cent)
rverts.tri.nd(dat,Tr,r,cent)

rverts.tri.nd(rbind(dat,dat),Tr,r,cent)

dat.fr<-data.frame(a=dat)
rverts.tri.nd(dat.fr,Tr,r,1)

dat.fr<-data.frame(a=Tr)
rverts.tri.nd(dat,dat.fr,r,1)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rverts.triCM}}, \code{\link{rverts.triCC}} and \code{\link{rverts.tri.cent}}
}
