% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndCSTet1}
\alias{IndCSTet1}
\title{The indicator for the presence of an arc from a point to another for Central Similarity Proximity Catch
Digraphs (CS-PCDs) - standard equilateral triangle case with \eqn{t=1}}
\usage{
IndCSTet1(pt1, pt2)
}
\arguments{
\item{pt1}{A 2D point whose CS proximity region is constructed.}

\item{pt2}{A 2D point. The function determines whether \code{pt2} is inside the CS proximity region of
\code{pt1} or not.}
}
\value{
I(\code{pt2} is in \eqn{NCS(pt1,t=1)}) for \code{pt1} in \eqn{T_e} that is, returns 1 if \code{pt2}
is in \eqn{NCS(pt1,t=1)}, returns 0 otherwise
}
\description{
Returns I(\code{pt2} is in \eqn{NCS(pt1,t=1)}) for points \code{pt1} and \code{pt2}, that is, returns 1 if \code{pt2} is in \eqn{NCS(pt1,t=1)},
returns 0 otherwise, where \eqn{NCS(x,t=1)} is the CS proximity region for point \eqn{x} with expansion parameter \eqn{t=1}.

CS proximity region is defined with respect to the standard equilateral triangle
\eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} and edge regions are based on the center of mass \eqn{CM=(1/2,\sqrt{3}/6)}.

If \code{pt1} and \code{pt2} are distint and either are outside \eqn{T_e}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).
}
\examples{
\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runifTe(n)$gen.points

IndCSTet1(dat[1,],dat[2,])
IndCSTet1(dat[1,],dat[1,])

IndCSTet1(dat[2,],dat[5,])
IndCSTet1(c(.2,.5),dat[2,])

IndCSTet1(c(.2,.5),c(.2,.5))

IndCSTet1(dat[1,],dat[7,])
}

}
\seealso{
\code{\link{IndCSTe}}
}
