% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcadapt.R
\name{computeStats}
\alias{computeStats}
\title{Test Statistics}
\usage{
computeStats(data, res, method, nSNP, K, data.type, min.maf)
}
\arguments{
\item{data}{a data matrix or a data frame if `PCAdapt = FALSE`.}

\item{res}{a list of quantities among which are the loadings.}

\item{method}{a character string that specifies the method used to compute the p-values.}

\item{nSNP}{an integer specifying the number of genetic markers.}

\item{K}{an integer specifying the number of principal components to retain.}

\item{data.type}{a character string that specifies the type of data being read, either a \code{genotype} matrix (\code{data.type="genotype"}), 
or a matrix of allele frequencies (\code{data.type="pool"}, or outputs from the software PCAdapt (\code{data.type="PCAdapt"}).}

\item{min.maf}{a value between \code{0} and \code{0.5} specifying the threshold of minor allele frequencies above which p-values are computed.}
}
\description{
\code{computeStats} computes the test statistics for each genetic marker.
}
\examples{
## see ?pcadapt for examples

}
\keyword{internal}

