% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_pbox.R
\name{make_pbox}
\alias{make_pbox}
\alias{make_pbox,ANY-method}
\title{Create a Probability Box (Pbox) Object}
\usage{
make_pbox(data, cop)

\S4method{make_pbox}{ANY}(data, cop)
}
\arguments{
\item{data}{A dataframe or data table; this data will be coerced to a `data.table` internally.}

\item{cop}{An object of class `mvdc` representing the multivariate dependency structure (copula).}
}
\value{
An object of class `pbox` with slots:
        - `$data`: The data coerced into a `data.table`.
        - `$copula`: The provided copula object.
}
\description{
Constructs a probability box (Pbox) object from a given dataset and a pre-defined copula model. This
auxiliary method facilitates the integration of data with a copula to form a comprehensive probabilistic
model known as a Pbox.

Method for creating a `pbox` object using a specified copula and data. This method ensures
that the input data and copula are compatible in terms of dimensions and structurally fit
to form a Pbox.
}
\examples{
  library(copula)
  data("SEAex")

  cop <- normalCopula(param = 0.5, dim = 4)
  distList <- c("RG", "SN1", "RG", "RG")
  allDistrs <- list(list(mu = 31.07, sigma = 0.28),
                    list(mu = 34.4, sigma = 0.98, nu = 1.7),
                    list(mu = 31.4, sigma = 0.34),
                    list(mu = 25.6, sigma = 0.24))
  copSEA <- mvdc(cop, distList, allDistrs)
  pbx <- make_pbox(data = SEAex, cop = copSEA)
  print(class(pbx))
}
