% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_copula.R
\docType{methods}
\name{fit_copula}
\alias{fit_copula}
\alias{.fit_copula}
\alias{.fit_copula,ANY-method}
\title{Copula Fit}
\usage{
.fit_copula(copula, family, dim, u)

\S4method{.fit_copula}{ANY}(copula, family, dim, u)
}
\arguments{
\item{copula}{A \code{data.frame} or \code{data.table} (the data will be coerced to a \code{data.table} internally).}

\item{family}{List of copula types and their corresponding families. Currently supported families are "clayton", "frank", "amh", "gumbel", and "joe" for Archimedean Copula; "galambos", "gumbel", and "huslerReiss" for Extreme-Value copula; "normal" and "t" for Elliptical copula.}

\item{dim}{number of columns of data.}

\item{u}{matrix of (pseudo-)observations. Consider applying the function \code{pobs()} first in order to obtain such data.}
}
\value{
A \code{data.table} with the corresponding AIC and the parameter estimates of the evaluated copulas and families.
}
\description{
Internal method to automatically find the best Copula given a data.frame. Wrapper around the function \code{fitCopula}.

Automatically fits a copula model using the provided pseudo-observations.
This method supports various families of copulas and calculates the corresponding AIC
and parameter estimates.
}
