\name{InitGrid}
\alias{InitGrid}

\alias{init.grid}
\alias{blacs_gridinit}

\title{ Initialize Process Grid }
\description{
  Manages the creation of BLACS context grids.
}
\usage{
  init.grid(NPROW, NPCOL, ICTXT, ..., quiet = FALSE)
  blacs_gridinit(ICTXT, NPROW, NPCOL, ..., quiet = FALSE)
}
\arguments{
  \item{NPROW}{number of process rows. Can be missing; see details.}
  \item{NPCOL}{number of process columns. Can be missing; see details.}
  \item{ICTXT}{BLACS context number.}
  \item{...}{additional arguments.}
  \item{quiet}{logical; controls whether or not information about grid
  size should be printed.}
}
\details{
  \code{blacs_gridinit()} is for experienced users only.  It is a shallow
  wrapper of the BLACS routine \code{BLACS_GRIDINIT}, with the addition 
  of creating the \code{.__blacs_gridinfo_ICTXT} objects, as described
  below.
  
  
  The remainder of this section applies only to \code{init.grid()}.
  
  If \code{ICTXT} is missing, three variables will be created in the
  \code{.pbdBASEEnv} environment:
  
  \code{.__blacs_gridinfo_0}
  
  \code{.__blacs_gridinfo_1}
  
  \code{.__blacs_gridinfo_2}

  These variables store the BLACS process grid information for the BLACS
  context corresponding to the trailing digit of the variable. Most users should
  invoke \code{init.grid()} in this fashion, namely with ICTXT missing, and only
  do so once.
  
  Contexts 0, 1, and 2 are reserved. Additional custom contexts
  are possible to create, but they must be integers >= 3.
  
  Context 0 is the ``full'' process grid of \code{NPROW} by \code{NPCOL} 
  processes; contexts 1 is the process grid consisting of 1 process row and 
  \code{NPROW}*\code{NPCOL} processes columns; context 2 is the process grid
  consisting of \code{NPROW}*\code{NPCOL} processes rows and 1 process column. 
  These contexts can be redundant depending on the number of prcesses available.
  
  BLACS contexts have important internal use, and advanced users familiar with 
  ScaLAPACK might find some advantage in directly manipulating these process 
  grids. Most users should not need to directly manage BLACS contexts, in this 
  function or elsewhere.
  
  If the \code{NPROW} and \code{NPCOL} values are missing, then a best process
  grid will be chosen for the user based on the total available number of
  processes. Here ``best'' means as close to a square grid as possible.
  
  The variables \code{.__blacs_gridinfo_ICTXT} are just storage mechanisms
  to avoid needing to directly invoke the BLACS routine \code{BLACS_GRIDINFO}.

  Additionally, another variable is created in the \code{.pbdBASEEnv}
  environment, namely \code{.__blacs_initialized}. Its existence 
  is to alert \code{finalize()} to shut down BLACS communicators, if
  necessary, to prevent memory leaks.
}
\value{
  Silently returns 0 when successful. Additionally, several variables
  are created in the \code{.pbdBASEEnv} environment.  See Details 
  section.
}
\seealso{
  \link{BLACS}
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdBASE, quiet = TRUE)
init.grid()

finalize()
}
}
\keyword{BLACS}
