####################################################################
# Thomas Hoffmann                                                  #
# CREATED:  05/??/06                                               #
#                                                                  #
# DESCRIPTION:                                                     #
#  Contains cleaning routines (manual currently)                   #
####################################################################

########################################################################
## pbat.clean(...)                                                     #
## DESCRIPTION: Gets rid of some of the output of pbat.                #
## PARAM:  pbatObj     'pbat' object                                   #
##         plots       TRUE/FALSE - delete plot output                 #
##         all.output  TRUE/FALSE - delete _all_ output - use with     #
##                                  caution (deletes all of pbat logs  #
##                                  as well.                           #
## CAUTION: do NOT name any useful files                               #
##            pbatlog... , pbatstatus.txt, spluscode.txt               #
##          This goes for pbat as well as pbatR.                       #
########################################################################
pbat.clean <- function( pbatObj, plots=TRUE, all.output=FALSE ){
  if( is.null(pbatObj) )
    pbatObj <- pbat.last();
  
  # Safely delete a file, useful warning on error
  safedel <- function( filename, warn=NULL ){
    if( is.character(filename) && file.exists(filename) ){
      file.remove(filename);
    }else{
      ## Too many of these warnings are meaningless; remove them all
      #if( !is.null(warn) ){
      #  warning( warn );
      #}
    }
  }

  ## Calling file
  ###if( is.character(pbatObj$pbat.call) ) {
  ###  safedel( pbatObj$pbat.call, 'pbat.clean: Cannot remove calling file.' );
  ###}else
  ###if( is.character( pbatObj$results.logfile ) ){ ## we don't really store that name I guess; reform it.
  ###  cmdfname <- substring( pbatObj$results.logfile, 1, strlen(pbatObj$results.logfile)-4 );
  ###  cmdfname <- paste( cmdfname, "cmd.txt", sep="" );
  ###  safedel( cmdfname, 'pbat.clean: Cannot remove calling file.' );
  ###}

  if( is.character( pbatObj$commandfile ) )
    safedel( pbatObj$commandfile );

  ## The data files
  if( is.character( pbatObj$results.logfile ) ){
    pedfile <- paste( pbatObj$results.logfile, ".ped", sep="" );
    phefile <- paste( pbatObj$results.logfile, ".phe", sep="" );

    safedel( pedfile, 'pbat.clean: Cannot remove temporary pedigree datafile.' );
    safedel( phefile, 'pbat.clean: Cannot remove temporary pedigree datafile.' );

    ## And the output from pbat - have to be careful for multi-processor mode
    datafiles <- dir( pattern=paste( pbatObj$results.logfile, ".*", sep="" ) );
    if( length(datafiles) > 0 ) {
      for( i in 1:length(datafiles) )
        safedel( datafiles[i] );
        ##safedel( datafiles[i], 'pbat.clean: Cannot remove pbat results file.' );
    }
    safedel( pbatObj$results.logfile );
  }

  ## And lastly the plot-generating output
  if( plots==TRUE & is.character( pbatObj$rcode ) )
    safedel( pbatObj$rcode, 'pbat.clean: Cannot remove temporary plotting sourcefile.' );

  ## What about the pbatlog files and pbatstatus files generated by pbat?
  if( all.output==TRUE ){
#     safedel("pbatstatus.txt");
#     safedel("spluscode.txt");
#     ## delete all output from pbat - WARNING - not just from this run!
# 
#     pbatlogs <- dir( pattern="pbatlog.*" ); # regular expressions
#     if( length(pbatlogs)>0 ) {
#       for( i in 1:length(pbatlogs) )
#         safedel( pbatlogs );
#     }
  }
}
