% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{kendra}
\alias{kendra}
\title{AWSKendraFrontendService}
\usage{
kendra(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Kendra is a service for indexing large document sets.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- kendra(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.analytics:kendra_associate_entities_to_experience]{associate_entities_to_experience} \tab Grants users or groups in your IAM Identity Center identity source access to your Amazon Kendra experience\cr
\link[paws.analytics:kendra_associate_personas_to_entities]{associate_personas_to_entities} \tab Defines the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience\cr
\link[paws.analytics:kendra_batch_delete_document]{batch_delete_document} \tab Removes one or more documents from an index\cr
\link[paws.analytics:kendra_batch_delete_featured_results_set]{batch_delete_featured_results_set} \tab Removes one or more sets of featured results\cr
\link[paws.analytics:kendra_batch_get_document_status]{batch_get_document_status} \tab Returns the indexing status for one or more documents submitted with the BatchPutDocument API\cr
\link[paws.analytics:kendra_batch_put_document]{batch_put_document} \tab Adds one or more documents to an index\cr
\link[paws.analytics:kendra_clear_query_suggestions]{clear_query_suggestions} \tab Clears existing query suggestions from an index\cr
\link[paws.analytics:kendra_create_access_control_configuration]{create_access_control_configuration} \tab Creates an access configuration for your documents\cr
\link[paws.analytics:kendra_create_data_source]{create_data_source} \tab Creates a data source connector that you want to use with an Amazon Kendra index\cr
\link[paws.analytics:kendra_create_experience]{create_experience} \tab Creates an Amazon Kendra experience such as a search application\cr
\link[paws.analytics:kendra_create_faq]{create_faq} \tab Creates a set of frequently ask questions (FAQs) using a specified FAQ file stored in an Amazon S3 bucket\cr
\link[paws.analytics:kendra_create_featured_results_set]{create_featured_results_set} \tab Creates a set of featured results to display at the top of the search results page\cr
\link[paws.analytics:kendra_create_index]{create_index} \tab Creates an Amazon Kendra index\cr
\link[paws.analytics:kendra_create_query_suggestions_block_list]{create_query_suggestions_block_list} \tab Creates a block list to exlcude certain queries from suggestions\cr
\link[paws.analytics:kendra_create_thesaurus]{create_thesaurus} \tab Creates a thesaurus for an index\cr
\link[paws.analytics:kendra_delete_access_control_configuration]{delete_access_control_configuration} \tab Deletes an access control configuration that you created for your documents in an index\cr
\link[paws.analytics:kendra_delete_data_source]{delete_data_source} \tab Deletes an Amazon Kendra data source connector\cr
\link[paws.analytics:kendra_delete_experience]{delete_experience} \tab Deletes your Amazon Kendra experience such as a search application\cr
\link[paws.analytics:kendra_delete_faq]{delete_faq} \tab Removes an FAQ from an index\cr
\link[paws.analytics:kendra_delete_index]{delete_index} \tab Deletes an Amazon Kendra index\cr
\link[paws.analytics:kendra_delete_principal_mapping]{delete_principal_mapping} \tab Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group\cr
\link[paws.analytics:kendra_delete_query_suggestions_block_list]{delete_query_suggestions_block_list} \tab Deletes a block list used for query suggestions for an index\cr
\link[paws.analytics:kendra_delete_thesaurus]{delete_thesaurus} \tab Deletes an Amazon Kendra thesaurus\cr
\link[paws.analytics:kendra_describe_access_control_configuration]{describe_access_control_configuration} \tab Gets information about an access control configuration that you created for your documents in an index\cr
\link[paws.analytics:kendra_describe_data_source]{describe_data_source} \tab Gets information about an Amazon Kendra data source connector\cr
\link[paws.analytics:kendra_describe_experience]{describe_experience} \tab Gets information about your Amazon Kendra experience such as a search application\cr
\link[paws.analytics:kendra_describe_faq]{describe_faq} \tab Gets information about an FAQ list\cr
\link[paws.analytics:kendra_describe_featured_results_set]{describe_featured_results_set} \tab Gets information about a set of featured results\cr
\link[paws.analytics:kendra_describe_index]{describe_index} \tab Gets information about an Amazon Kendra index\cr
\link[paws.analytics:kendra_describe_principal_mapping]{describe_principal_mapping} \tab Describes the processing of PUT and DELETE actions for mapping users to their groups\cr
\link[paws.analytics:kendra_describe_query_suggestions_block_list]{describe_query_suggestions_block_list} \tab Gets information about a block list used for query suggestions for an index\cr
\link[paws.analytics:kendra_describe_query_suggestions_config]{describe_query_suggestions_config} \tab Gets information on the settings of query suggestions for an index\cr
\link[paws.analytics:kendra_describe_thesaurus]{describe_thesaurus} \tab Gets information about an Amazon Kendra thesaurus\cr
\link[paws.analytics:kendra_disassociate_entities_from_experience]{disassociate_entities_from_experience} \tab Prevents users or groups in your IAM Identity Center identity source from accessing your Amazon Kendra experience\cr
\link[paws.analytics:kendra_disassociate_personas_from_entities]{disassociate_personas_from_entities} \tab Removes the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience\cr
\link[paws.analytics:kendra_get_query_suggestions]{get_query_suggestions} \tab Fetches the queries that are suggested to your users\cr
\link[paws.analytics:kendra_get_snapshots]{get_snapshots} \tab Retrieves search metrics data\cr
\link[paws.analytics:kendra_list_access_control_configurations]{list_access_control_configurations} \tab Lists one or more access control configurations for an index\cr
\link[paws.analytics:kendra_list_data_sources]{list_data_sources} \tab Lists the data source connectors that you have created\cr
\link[paws.analytics:kendra_list_data_source_sync_jobs]{list_data_source_sync_jobs} \tab Gets statistics about synchronizing a data source connector\cr
\link[paws.analytics:kendra_list_entity_personas]{list_entity_personas} \tab Lists specific permissions of users and groups with access to your Amazon Kendra experience\cr
\link[paws.analytics:kendra_list_experience_entities]{list_experience_entities} \tab Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra experience\cr
\link[paws.analytics:kendra_list_experiences]{list_experiences} \tab Lists one or more Amazon Kendra experiences\cr
\link[paws.analytics:kendra_list_faqs]{list_faqs} \tab Gets a list of FAQ lists associated with an index\cr
\link[paws.analytics:kendra_list_featured_results_sets]{list_featured_results_sets} \tab Lists all your sets of featured results for a given index\cr
\link[paws.analytics:kendra_list_groups_older_than_ordering_id]{list_groups_older_than_ordering_id} \tab Provides a list of groups that are mapped to users before a given ordering or timestamp identifier\cr
\link[paws.analytics:kendra_list_indices]{list_indices} \tab Lists the Amazon Kendra indexes that you created\cr
\link[paws.analytics:kendra_list_query_suggestions_block_lists]{list_query_suggestions_block_lists} \tab Lists the block lists used for query suggestions for an index\cr
\link[paws.analytics:kendra_list_tags_for_resource]{list_tags_for_resource} \tab Gets a list of tags associated with a specified resource\cr
\link[paws.analytics:kendra_list_thesauri]{list_thesauri} \tab Lists the thesauri for an index\cr
\link[paws.analytics:kendra_put_principal_mapping]{put_principal_mapping} \tab Maps users to their groups so that you only need to provide the user ID when you issue the query\cr
\link[paws.analytics:kendra_query]{query} \tab Searches an index given an input query\cr
\link[paws.analytics:kendra_retrieve]{retrieve} \tab Retrieves relevant passages or text excerpts given an input query\cr
\link[paws.analytics:kendra_start_data_source_sync_job]{start_data_source_sync_job} \tab Starts a synchronization job for a data source connector\cr
\link[paws.analytics:kendra_stop_data_source_sync_job]{stop_data_source_sync_job} \tab Stops a synchronization job that is currently running\cr
\link[paws.analytics:kendra_submit_feedback]{submit_feedback} \tab Enables you to provide feedback to Amazon Kendra to improve the performance of your index\cr
\link[paws.analytics:kendra_tag_resource]{tag_resource} \tab Adds the specified tag to the specified index, FAQ, or data source resource\cr
\link[paws.analytics:kendra_untag_resource]{untag_resource} \tab Removes a tag from an index, FAQ, or a data source\cr
\link[paws.analytics:kendra_update_access_control_configuration]{update_access_control_configuration} \tab Updates an access control configuration for your documents in an index\cr
\link[paws.analytics:kendra_update_data_source]{update_data_source} \tab Updates an Amazon Kendra data source connector\cr
\link[paws.analytics:kendra_update_experience]{update_experience} \tab Updates your Amazon Kendra experience such as a search application\cr
\link[paws.analytics:kendra_update_featured_results_set]{update_featured_results_set} \tab Updates a set of featured results\cr
\link[paws.analytics:kendra_update_index]{update_index} \tab Updates an Amazon Kendra index\cr
\link[paws.analytics:kendra_update_query_suggestions_block_list]{update_query_suggestions_block_list} \tab Updates a block list used for query suggestions for an index\cr
\link[paws.analytics:kendra_update_query_suggestions_config]{update_query_suggestions_config} \tab Updates the settings of query suggestions for an index\cr
\link[paws.analytics:kendra_update_thesaurus]{update_thesaurus} \tab Updates a thesaurus for an index
}
}

\examples{
\dontrun{
svc <- kendra()
svc$associate_entities_to_experience(
  Foo = 123
)
}

}
