% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlm_operations.R
\name{dlm_get_lifecycle_policies}
\alias{dlm_get_lifecycle_policies}
\title{Gets summary information about all or the specified data lifecycle
policies}
\usage{
dlm_get_lifecycle_policies(
  PolicyIds = NULL,
  State = NULL,
  ResourceTypes = NULL,
  TargetTags = NULL,
  TagsToAdd = NULL,
  DefaultPolicyType = NULL
)
}
\arguments{
\item{PolicyIds}{The identifiers of the data lifecycle policies.}

\item{State}{The activation state.}

\item{ResourceTypes}{The resource type.}

\item{TargetTags}{The target tag for a policy.

Tags are strings in the format \code{key=value}.}

\item{TagsToAdd}{The tags to add to objects created by the policy.

Tags are strings in the format \code{key=value}.

These user-defined tags are added in addition to the Amazon Web
Services-added lifecycle tags.}

\item{DefaultPolicyType}{\strong{[Default policies only]} Specifies the type of default policy to
get. Specify one of the following:
\itemize{
\item \code{VOLUME} - To get only the default policy for EBS snapshots
\item \code{INSTANCE} - To get only the default policy for EBS-backed AMIs
\item \code{ALL} - To get all default policies
}}
}
\description{
Gets summary information about all or the specified data lifecycle policies.

See \url{https://www.paws-r-sdk.com/docs/dlm_get_lifecycle_policies/} for full documentation.
}
\keyword{internal}
