% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_multipart_uploads}
\alias{s3_list_multipart_uploads}
\title{This action lists in-progress multipart uploads}
\usage{
s3_list_multipart_uploads(
  Bucket,
  Delimiter = NULL,
  EncodingType = NULL,
  KeyMarker = NULL,
  MaxUploads = NULL,
  Prefix = NULL,
  UploadIdMarker = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket to which the multipart upload was initiated.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When you use this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When you use this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts access point ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{What is S3 on Outposts}
in the \emph{Amazon S3 User Guide}.}

\item{Delimiter}{Character you use to group keys.

All keys that contain the same string between the prefix, if specified,
and the first occurrence of the delimiter after the prefix are grouped
under a single result element, \code{CommonPrefixes}. If you don't specify
the prefix parameter, then the substring starts at the beginning of the
key. The keys that are grouped under \code{CommonPrefixes} result element are
not returned elsewhere in the response.}

\item{EncodingType}{}

\item{KeyMarker}{Together with upload-id-marker, this parameter specifies the multipart
upload after which listing should begin.

If \code{upload-id-marker} is not specified, only the keys lexicographically
greater than the specified \code{key-marker} will be included in the list.

If \code{upload-id-marker} is specified, any multipart uploads for a key
equal to the \code{key-marker} might also be included, provided those
multipart uploads have upload IDs lexicographically greater than the
specified \code{upload-id-marker}.}

\item{MaxUploads}{Sets the maximum number of multipart uploads, from 1 to 1,000, to return
in the response body. 1,000 is the maximum number of uploads that can be
returned in a response.}

\item{Prefix}{Lists in-progress uploads only for those keys that begin with the
specified prefix. You can use prefixes to separate a bucket into
different grouping of keys. (You can think of using prefix to make
groups in the same way you'd use a folder in a file system.)}

\item{UploadIdMarker}{Together with key-marker, specifies the multipart upload after which
listing should begin. If key-marker is not specified, the
upload-id-marker parameter is ignored. Otherwise, any multipart uploads
for a key equal to the key-marker might be included in the list only if
they have an upload ID lexicographically greater than the specified
\code{upload-id-marker}.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
This action lists in-progress multipart uploads. An in-progress multipart upload is a multipart upload that has been initiated using the Initiate Multipart Upload request, but has not yet been completed or aborted.

See \url{https://www.paws-r-sdk.com/docs/s3_list_multipart_uploads/} for full documentation.
}
\keyword{internal}
