# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Backup Storage
#'
#' @description
#' The frontend service for Cryo Storage.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- backupstorage(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- backupstorage()
#' svc$delete_object(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=backupstorage_delete_object]{delete_object} \tab Delete Object from the incremental base Backup\cr
#'  \link[=backupstorage_get_chunk]{get_chunk} \tab Gets the specified object's chunk\cr
#'  \link[=backupstorage_get_object_metadata]{get_object_metadata} \tab Get metadata associated with an Object\cr
#'  \link[=backupstorage_list_chunks]{list_chunks} \tab List chunks in a given Object\cr
#'  \link[=backupstorage_list_objects]{list_objects} \tab List all Objects in a given Backup\cr
#'  \link[=backupstorage_notify_object_complete]{notify_object_complete} \tab Complete upload\cr
#'  \link[=backupstorage_put_chunk]{put_chunk} \tab Upload chunk\cr
#'  \link[=backupstorage_put_object]{put_object} \tab Upload object that can store object metadata String and data blob in single API call using inline chunk field\cr
#'  \link[=backupstorage_start_object]{start_object} \tab Start upload containing one or many chunks
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname backupstorage
#' @export
backupstorage <- function(config = list()) {
  svc <- .backupstorage$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.backupstorage <- list()

.backupstorage$operations <- list()

.backupstorage$metadata <- list(
  service_name = "backupstorage",
  endpoints = list("*" = list(endpoint = "backupstorage.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "backupstorage.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "backupstorage.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "backupstorage.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "BackupStorage",
  api_version = "2018-04-10",
  signing_name = "backup-storage",
  json_version = "1.1",
  target_prefix = ""
)

.backupstorage$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.backupstorage$metadata, handlers, config)
}
