% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_disassociate_file_system}
\alias{storagegateway_disassociate_file_system}
\title{Disassociates an Amazon FSx file system from the specified gateway}
\usage{
storagegateway_disassociate_file_system(
  FileSystemAssociationARN,
  ForceDelete = NULL
)
}
\arguments{
\item{FileSystemAssociationARN}{[required] The Amazon Resource Name (ARN) of the file system association to be
deleted.}

\item{ForceDelete}{If this value is set to true, the operation disassociates an Amazon FSx
file system immediately. It ends all data uploads to the file system,
and the file system association enters the \code{FORCE_DELETING} status. If
this value is set to false, the Amazon FSx file system does not
disassociate until all data is uploaded.}
}
\description{
Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes, the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File Gateway type.

See \url{https://paws-r.github.io/docs/storagegateway/disassociate_file_system.html} for full documentation.
}
\keyword{internal}
