% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_objects_v2}
\alias{s3_list_objects_v2}
\title{Returns some or all (up to 1,000) of the objects in a bucket with each
request}
\usage{
s3_list_objects_v2(
  Bucket,
  Delimiter = NULL,
  EncodingType = NULL,
  MaxKeys = NULL,
  Prefix = NULL,
  ContinuationToken = NULL,
  FetchOwner = NULL,
  StartAfter = NULL,
  RequestPayer = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] Bucket name to list.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When using this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When using this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts bucket ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{Using Amazon S3 on Outposts}
in the \emph{Amazon S3 User Guide}.}

\item{Delimiter}{A delimiter is a character you use to group keys.}

\item{EncodingType}{Encoding type used by Amazon S3 to encode object keys in the response.}

\item{MaxKeys}{Sets the maximum number of keys returned in the response. By default the
action returns up to 1,000 key names. The response might contain fewer
keys but will never contain more.}

\item{Prefix}{Limits the response to keys that begin with the specified prefix.}

\item{ContinuationToken}{ContinuationToken indicates Amazon S3 that the list is being continued
on this bucket with a token. ContinuationToken is obfuscated and is not
a real key.}

\item{FetchOwner}{The owner field is not present in listV2 by default, if you want to
return owner field with each key in the result then set the fetch owner
field to true.}

\item{StartAfter}{StartAfter is where you want Amazon S3 to start listing from. Amazon S3
starts listing after this specified key. StartAfter can be any key in
the bucket.}

\item{RequestPayer}{Confirms that the requester knows that she or he will be charged for the
list objects request in V2 style. Bucket owners need not specify this
parameter in their requests.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Returns some or all (up to 1,000) of the objects in a bucket with each request. You can use the request parameters as selection criteria to return a subset of the objects in a bucket. A \verb{200 OK} response can contain valid or invalid XML. Make sure to design your application to parse the contents of the response and handle it appropriately. Objects are returned sorted in an ascending order of the respective key names in the list. For more information about listing objects, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/ListingKeysUsingAPIs.html}{Listing object keys programmatically}

See \url{https://paws-r.github.io/docs/s3/list_objects_v2.html} for full documentation.
}
\keyword{internal}
