% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_bandwidth_rate_limit}
\alias{storagegateway_update_bandwidth_rate_limit}
\title{Updates the bandwidth rate limits of a gateway}
\usage{
storagegateway_update_bandwidth_rate_limit(GatewayARN,
  AverageUploadRateLimitInBitsPerSec,
  AverageDownloadRateLimitInBitsPerSec)
}
\arguments{
\item{GatewayARN}{[required]}

\item{AverageUploadRateLimitInBitsPerSec}{The average upload bandwidth rate limit in bits per second.}

\item{AverageDownloadRateLimitInBitsPerSec}{The average download bandwidth rate limit in bits per second.}
}
\description{
Updates the bandwidth rate limits of a gateway. You can update both the
upload and download bandwidth rate limit or specify only one of the two.
If you don\'t set a bandwidth rate limit, the existing rate limit
remains. This operation is supported for the stored volume, cached
volume, and tape gateway types.
}
\details{
By default, a gateway\'s bandwidth rate limits are not set. If you
don\'t set any limit, the gateway does not have any limitations on its
bandwidth usage and could potentially use the maximum available
bandwidth.

To specify which gateway to update, use the Amazon Resource Name (ARN)
of the gateway in your request.
}
\section{Request syntax}{
\preformatted{svc$update_bandwidth_rate_limit(
  GatewayARN = "string",
  AverageUploadRateLimitInBitsPerSec = 123,
  AverageDownloadRateLimitInBitsPerSec = 123
)
}
}

\examples{
\dontrun{
# Updates the bandwidth rate limits of a gateway. Both the upload and
# download bandwidth rate limit can be set, or either one of the two. If a
# new limit is not set, the existing rate limit remains.
svc$update_bandwidth_rate_limit(
  AverageDownloadRateLimitInBitsPerSec = 102400L,
  AverageUploadRateLimitInBitsPerSec = 51200L,
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
)
}

}
\keyword{internal}
