% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_reset_cache}
\alias{storagegateway_reset_cache}
\title{Resets all cache disks that have encountered an error and makes the
disks available for reconfiguration as cache storage}
\usage{
storagegateway_reset_cache(GatewayARN)
}
\arguments{
\item{GatewayARN}{[required]}
}
\description{
Resets all cache disks that have encountered an error and makes the
disks available for reconfiguration as cache storage. If your cache disk
encounters an error, the gateway prevents read and write operations on
virtual tapes in the gateway. For example, an error can occur when a
disk is corrupted or removed from the gateway. When a cache is reset,
the gateway loses its cache storage. At this point, you can reconfigure
the disks as cache disks. This operation is only supported in the cached
volume and tape types.
}
\details{
If the cache disk you are resetting contains data that has not been
uploaded to Amazon S3 yet, that data can be lost. After you reset cache
disks, there will be no configured cache disks left in the gateway, so
you must configure at least one new cache disk for your gateway to
function properly.
}
\section{Request syntax}{
\preformatted{svc$reset_cache(
  GatewayARN = "string"
)
}
}

\examples{
\dontrun{
# Resets all cache disks that have encountered a error and makes the disks
# available for reconfiguration as cache storage.
svc$reset_cache(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-13B4567C"
)
}

}
\keyword{internal}
