% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_delete_snapshot_schedule}
\alias{storagegateway_delete_snapshot_schedule}
\title{Deletes a snapshot of a volume}
\usage{
storagegateway_delete_snapshot_schedule(VolumeARN)
}
\arguments{
\item{VolumeARN}{[required] The volume which snapshot schedule to delete.}
}
\description{
Deletes a snapshot of a volume.
}
\details{
You can take snapshots of your gateway volumes on a scheduled or ad hoc
basis. This API action enables you to delete a snapshot schedule for a
volume. For more information, see \href{https://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html}{Working with Snapshots}.
In the \code{DeleteSnapshotSchedule} request, you identify the volume by
providing its Amazon Resource Name (ARN). This operation is only
supported in stored and cached volume gateway types.

To list or delete a snapshot, you must use the Amazon EC2 API. in
\emph{Amazon Elastic Compute Cloud API Reference}.
}
\section{Request syntax}{
\preformatted{svc$delete_snapshot_schedule(
  VolumeARN = "string"
)
}
}

\examples{
\dontrun{
# This action enables you to delete a snapshot schedule for a volume.
svc$delete_snapshot_schedule(
  VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
)
}

}
\keyword{internal}
