% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_gateway_software_now}
\alias{storagegateway_update_gateway_software_now}
\title{Updates the gateway virtual machine (VM) software}
\usage{
storagegateway_update_gateway_software_now(GatewayARN)
}
\arguments{
\item{GatewayARN}{[required]}
}
\description{
Updates the gateway virtual machine (VM) software. The request
immediately triggers the software update.
}
\details{
When you make this request, you get a \verb{200 OK} success response
immediately. However, it might take some time for the update to
complete. You can call DescribeGatewayInformation to verify the gateway
is in the \code{STATE_RUNNING} state.

A software update forces a system restart of your gateway. You can
minimize the chance of any disruption to your applications by increasing
your iSCSI Initiators\' timeouts. For more information about increasing
iSCSI Initiator timeouts for Windows and Linux, see \href{https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings}{Customizing Your Windows iSCSI Settings}
and \href{https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings}{Customizing Your Linux iSCSI Settings},
respectively.
}
\section{Request syntax}{
\preformatted{svc$update_gateway_software_now(
  GatewayARN = "string"
)
}
}

\examples{
# Updates the gateway virtual machine (VM) software. The request
# immediately triggers the software update.
\donttest{svc$update_gateway_software_now(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
)}

}
\keyword{internal}
