% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_logging}
\alias{s3_put_bucket_logging}
\title{Set the logging parameters for a bucket and to specify permissions for
who can view and modify the logging parameters}
\usage{
s3_put_bucket_logging(Bucket, BucketLoggingStatus, ContentMD5,
  ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to set the logging parameters.}

\item{BucketLoggingStatus}{[required] Container for logging status information.}

\item{ContentMD5}{The MD5 hash of the \code{PutBucketLogging} request body.

For requests made using the AWS Command Line Interface (CLI) or AWS
SDKs, this field is calculated automatically.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Set the logging parameters for a bucket and to specify permissions for
who can view and modify the logging parameters. All logs are saved to
buckets in the same AWS Region as the source bucket. To set the logging
status of a bucket, you must be the bucket owner.

The bucket owner is automatically granted FULL\\_CONTROL to all logs. You
use the \code{Grantee} request element to grant access to other people. The
\code{Permissions} request element specifies the kind of access the grantee
has to the logs.

\strong{Grantee Values}

You can specify the person (grantee) to whom you're assigning access
rights (using request elements) in the following ways:
\itemize{
\item By the person's ID:

\verb{&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser"&gt;&lt;ID&gt;&lt;&gt;ID&lt;&gt;&lt;/ID&gt;&lt;DisplayName&gt;&lt;&gt;GranteesEmail&lt;&gt;&lt;/DisplayName&gt; &lt;/Grantee&gt;}

DisplayName is optional and ignored in the request.
\item By Email address:

\verb{ &lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail"&gt;&lt;EmailAddress&gt;&lt;&gt;Grantees@email.com&lt;&gt;&lt;/EmailAddress&gt;&lt;/Grantee&gt;}

The grantee is resolved to the CanonicalUser and, in a response to a
GET Object acl request, appears as the CanonicalUser.
\item By URI:

\verb{&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group"&gt;&lt;URI&gt;&lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;&lt;/URI&gt;&lt;/Grantee&gt;}
}

To enable logging, you use LoggingEnabled and its children request
elements. To disable logging, you use an empty BucketLoggingStatus
request element:

\verb{&lt;BucketLoggingStatus xmlns="http://doc.s3.amazonaws.com/2006-03-01" /&gt;}

For more information about server access logging, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerLogs.html}{Server Access Logging}.

For more information about creating a bucket, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html}{CreateBucket}.
For more information about returning the logging status of a bucket, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html}{GetBucketLogging}.

The following operations are related to \code{PutBucketLogging}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html}{PutObject}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html}{DeleteBucket}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html}{CreateBucket}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html}{GetBucketLogging}
}
}
\section{Request syntax}{
\preformatted{svc$put_bucket_logging(
  Bucket = "string",
  BucketLoggingStatus = list(
    LoggingEnabled = list(
      TargetBucket = "string",
      TargetGrants = list(
        list(
          Grantee = list(
            DisplayName = "string",
            EmailAddress = "string",
            ID = "string",
            Type = "CanonicalUser"|"AmazonCustomerByEmail"|"Group",
            URI = "string"
          ),
          Permission = "FULL_CONTROL"|"READ"|"WRITE"
        )
      ),
      TargetPrefix = "string"
    )
  ),
  ContentMD5 = "string",
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example sets logging policy on a bucket. For the Log
# Delivery group to deliver logs to the destination bucket, it needs
# permission for the READ_ACP action which the policy grants.
svc$put_bucket_logging(
  Bucket = "sourcebucket",
  BucketLoggingStatus = list(
    LoggingEnabled = list(
      TargetBucket = "targetbucket",
      TargetGrants = list(
        list(
          Grantee = list(
            Type = "Group",
            URI = "http://acs.amazonaws.com/groups/global/AllUsers"
          ),
          Permission = "READ"
        )
      ),
      TargetPrefix = "MyBucketLogs/"
    )
  )
)
}

}
\keyword{internal}
