# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon Elastic File System
#'
#' @description
#' Amazon Elastic File System (Amazon EFS) provides simple, scalable file
#' storage for use with Amazon EC2 instances in the AWS Cloud. With Amazon
#' EFS, storage capacity is elastic, growing and shrinking automatically as
#' you add and remove files, so your applications have the storage they
#' need, when they need it. For more information, see the [User
#' Guide](https://docs.aws.amazon.com/efs/latest/ug/api-reference.html).
#'
#' @examples
#' # This operation creates a new file system with the default generalpurpose
#' # performance mode.
#' \donttest{svc <- efs()
#' svc$create_file_system(
#'   CreationToken = "tokenstring",
#'   PerformanceMode = "generalPurpose",
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyFileSystem"
#'     )
#'   )
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=efs_create_file_system]{create_file_system} \tab Creates a new, empty file system \cr
#'  \link[=efs_create_mount_target]{create_mount_target} \tab Creates a mount target for a file system \cr
#'  \link[=efs_create_tags]{create_tags} \tab Creates or overwrites tags associated with a file system \cr
#'  \link[=efs_delete_file_system]{delete_file_system} \tab Deletes a file system, permanently severing access to its contents \cr
#'  \link[=efs_delete_mount_target]{delete_mount_target} \tab Deletes the specified mount target \cr
#'  \link[=efs_delete_tags]{delete_tags} \tab Deletes the specified tags from a file system \cr
#'  \link[=efs_describe_file_systems]{describe_file_systems} \tab Returns the description of a specific Amazon EFS file system if either the file system CreationToken or the FileSystemId is provided\cr
#'  \link[=efs_describe_lifecycle_configuration]{describe_lifecycle_configuration} \tab Returns the current LifecycleConfiguration object for the specified Amazon EFS file system \cr
#'  \link[=efs_describe_mount_target_security_groups]{describe_mount_target_security_groups} \tab Returns the security groups currently in effect for a mount target \cr
#'  \link[=efs_describe_mount_targets]{describe_mount_targets} \tab Returns the descriptions of all the current mount targets, or a specific mount target, for a file system \cr
#'  \link[=efs_describe_tags]{describe_tags} \tab Returns the tags associated with a file system \cr
#'  \link[=efs_modify_mount_target_security_groups]{modify_mount_target_security_groups} \tab Modifies the set of security groups in effect for a mount target \cr
#'  \link[=efs_put_lifecycle_configuration]{put_lifecycle_configuration} \tab Enables lifecycle management by creating a new LifecycleConfiguration object \cr
#'  \link[=efs_update_file_system]{update_file_system} \tab Updates the throughput mode or the amount of provisioned throughput of an existing file system 
#' }
#'
#' @rdname efs
#' @export
efs <- function() {
  .efs$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.efs <- list()

.efs$operations <- list()

.efs$metadata <- list(
  service_name = "elasticfilesystem",
  endpoints = list("*" = "elasticfilesystem.{region}.amazonaws.com", "cn-*" = "elasticfilesystem.{region}.amazonaws.com.cn"),
  service_id = "EFS",
  api_version = "2015-02-01",
  signing_name = NULL,
  json_version = "",
  target_prefix = ""
)

.efs$handlers <- new_handlers("restjson", "v4")

.efs$service <- function() {
  new_service(.efs$metadata, .efs$handlers)
}
