% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_derive_shared_secret}
\alias{kms_derive_shared_secret}
\title{Derives a shared secret using a key agreement algorithm}
\usage{
kms_derive_shared_secret(
  KeyId,
  KeyAgreementAlgorithm,
  PublicKey,
  GrantTokens = NULL,
  DryRun = NULL,
  Recipient = NULL
)
}
\arguments{
\item{KeyId}{[required] Identifies an asymmetric NIST-recommended ECC or SM2 (China Regions
only) KMS key. KMS uses the private key in the specified key pair to
derive the shared secret. The key usage of the KMS key must be
\code{KEY_AGREEMENT}. To find the \code{KeyUsage} of a KMS key, use the
\code{\link[=kms_describe_key]{describe_key}} operation.

To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
When using an alias name, prefix it with \code{"alias/"}. To specify a KMS
key in a different Amazon Web Services account, you must use the key ARN
or alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{KeyAgreementAlgorithm}{[required] Specifies the key agreement algorithm used to derive the shared secret.
The only valid value is \code{ECDH}.}

\item{PublicKey}{[required] Specifies the public key in your peer's NIST-recommended elliptic curve
(ECC) or SM2 (China Regions only) key pair.

The public key must be a DER-encoded X.509 public key, also known as
\code{SubjectPublicKeyInfo} (SPKI), as defined in \href{https://datatracker.ietf.org/doc/html/rfc5280}{RFC 5280}.

\code{\link[=kms_get_public_key]{get_public_key}} returns the public key of an
asymmetric KMS key pair in the required DER-encoded format.

If you use \href{https://docs.aws.amazon.com/cli/v1/userguide/cli-chap-welcome.html}{Amazon Web Services CLI version 1},
you must provide the DER-encoded X.509 public key in a file. Otherwise,
the Amazon Web Services CLI Base64-encodes the public key a second time,
resulting in a \code{ValidationException}.

You can specify the public key as binary data in a file using fileb
(\verb{fileb://<path-to-file>}) or in-line using a Base64 encoded string.}

\item{GrantTokens}{A list of grant tokens.

Use a grant token when your permission to call this operation comes from
a new grant that has not yet achieved \emph{eventual consistency}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token}{Grant token}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#using-grant-token}{Using a grant token}
in the \emph{Key Management Service Developer Guide}.}

\item{DryRun}{Checks if your request will succeed. \code{DryRun} is an optional parameter.

To learn more about how to use this parameter, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/testing-permissions.html}{Testing your KMS API calls}
in the \emph{Key Management Service Developer Guide}.}

\item{Recipient}{A signed \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/#term-attestdoc}{attestation document}
from an Amazon Web Services Nitro enclave and the encryption algorithm
to use with the enclave's public key. The only valid encryption
algorithm is \code{RSAES_OAEP_SHA_256}.

This parameter only supports attestation documents for Amazon Web
Services Nitro Enclaves. To call DeriveSharedSecret for an Amazon Web
Services Nitro Enclaves, use the \href{https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk}{Amazon Web Services Nitro Enclaves SDK}
to generate the attestation document and then use the Recipient
parameter from any Amazon Web Services SDK to provide the attestation
document for the enclave.

When you use this parameter, instead of returning a plaintext copy of
the shared secret, KMS encrypts the plaintext shared secret under the
public key in the attestation document, and returns the resulting
ciphertext in the \code{CiphertextForRecipient} field in the response. This
ciphertext can be decrypted only with the private key in the enclave.
The \code{CiphertextBlob} field in the response contains the encrypted shared
secret derived from the KMS key specified by the \code{KeyId} parameter and
public key specified by the \code{PublicKey} parameter. The \code{SharedSecret}
field in the response is null or empty.

For information about the interaction between KMS and Amazon Web
Services Nitro Enclaves, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html}{How Amazon Web Services Nitro Enclaves uses KMS}
in the \emph{Key Management Service Developer Guide}.}
}
\description{
Derives a shared secret using a key agreement algorithm.

See \url{https://www.paws-r-sdk.com/docs/kms_derive_shared_secret/} for full documentation.
}
\keyword{internal}
