% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_publishing_destination}
\alias{guardduty_create_publishing_destination}
\title{Creates a publishing destination where you can export your GuardDuty
findings}
\usage{
guardduty_create_publishing_destination(
  DetectorId,
  DestinationType,
  DestinationProperties,
  ClientToken = NULL
)
}
\arguments{
\item{DetectorId}{[required] The ID of the GuardDuty detector associated with the publishing
destination.

To find the \code{detectorId} in the current Region, see the Settings page in
the GuardDuty console, or run the
\code{\link[=guardduty_list_detectors]{list_detectors}} API.}

\item{DestinationType}{[required] The type of resource for the publishing destination. Currently only
Amazon S3 buckets are supported.}

\item{DestinationProperties}{[required] The properties of the publishing destination, including the ARNs for the
destination and the KMS key used for encryption.}

\item{ClientToken}{The idempotency token for the request.}
}
\description{
Creates a publishing destination where you can export your GuardDuty findings. Before you start exporting the findings, the destination resource must exist.

See \url{https://www.paws-r-sdk.com/docs/guardduty_create_publishing_destination/} for full documentation.
}
\keyword{internal}
