# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include identitystore_service.R
NULL

#' Creates a group within the specified identity store
#'
#' @description
#' Creates a group within the specified identity store.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_create_group/](https://www.paws-r-sdk.com/docs/identitystore_create_group/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param DisplayName A string containing the name of the group. This value is commonly
#' displayed when the group is referenced. `Administrator` and
#' `AWSAdministrators` are reserved names and can't be used for users or
#' groups.
#' @param Description A string containing the description of the group.
#'
#' @keywords internal
#'
#' @rdname identitystore_create_group
identitystore_create_group <- function(IdentityStoreId, DisplayName = NULL, Description = NULL) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$create_group_input(IdentityStoreId = IdentityStoreId, DisplayName = DisplayName, Description = Description)
  output <- .identitystore$create_group_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$create_group <- identitystore_create_group

#' Creates a relationship between a member and a group
#'
#' @description
#' Creates a relationship between a member and a group. The following identifiers must be specified: `GroupId`, `IdentityStoreId`, and `MemberId`.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_create_group_membership/](https://www.paws-r-sdk.com/docs/identitystore_create_group_membership/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param GroupId &#91;required&#93; The identifier for a group in the identity store.
#' @param MemberId &#91;required&#93; An object that contains the identifier of a group member. Setting the
#' `UserID` field to the specific identifier for a user indicates that the
#' user is a member of the group.
#'
#' @keywords internal
#'
#' @rdname identitystore_create_group_membership
identitystore_create_group_membership <- function(IdentityStoreId, GroupId, MemberId) {
  op <- new_operation(
    name = "CreateGroupMembership",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$create_group_membership_input(IdentityStoreId = IdentityStoreId, GroupId = GroupId, MemberId = MemberId)
  output <- .identitystore$create_group_membership_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$create_group_membership <- identitystore_create_group_membership

#' Creates a user within the specified identity store
#'
#' @description
#' Creates a user within the specified identity store.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_create_user/](https://www.paws-r-sdk.com/docs/identitystore_create_user/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param UserName A unique string used to identify the user. The length limit is 128
#' characters. This value can consist of letters, accented characters,
#' symbols, numbers, and punctuation. This value is specified at the time
#' the user is created and stored as an attribute of the user object in the
#' identity store. `Administrator` and `AWSAdministrators` are reserved
#' names and can't be used for users or groups.
#' @param Name An object containing the name of the user.
#' @param DisplayName A string containing the name of the user. This value is typically
#' formatted for display when the user is referenced. For example, "John
#' Doe."
#' @param NickName A string containing an alternate name for the user.
#' @param ProfileUrl A string containing a URL that might be associated with the user.
#' @param Emails A list of `Email` objects containing email addresses associated with the
#' user.
#' @param Addresses A list of `Address` objects containing addresses associated with the
#' user.
#' @param PhoneNumbers A list of `PhoneNumber` objects containing phone numbers associated with
#' the user.
#' @param UserType A string indicating the type of user. Possible values are left
#' unspecified. The value can vary based on your specific use case.
#' @param Title A string containing the title of the user. Possible values are left
#' unspecified. The value can vary based on your specific use case.
#' @param PreferredLanguage A string containing the preferred language of the user. For example,
#' "American English" or "en-us."
#' @param Locale A string containing the geographical region or location of the user.
#' @param Timezone A string containing the time zone of the user.
#'
#' @keywords internal
#'
#' @rdname identitystore_create_user
identitystore_create_user <- function(IdentityStoreId, UserName = NULL, Name = NULL, DisplayName = NULL, NickName = NULL, ProfileUrl = NULL, Emails = NULL, Addresses = NULL, PhoneNumbers = NULL, UserType = NULL, Title = NULL, PreferredLanguage = NULL, Locale = NULL, Timezone = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$create_user_input(IdentityStoreId = IdentityStoreId, UserName = UserName, Name = Name, DisplayName = DisplayName, NickName = NickName, ProfileUrl = ProfileUrl, Emails = Emails, Addresses = Addresses, PhoneNumbers = PhoneNumbers, UserType = UserType, Title = Title, PreferredLanguage = PreferredLanguage, Locale = Locale, Timezone = Timezone)
  output <- .identitystore$create_user_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$create_user <- identitystore_create_user

#' Delete a group within an identity store given GroupId
#'
#' @description
#' Delete a group within an identity store given `GroupId`.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_delete_group/](https://www.paws-r-sdk.com/docs/identitystore_delete_group/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param GroupId &#91;required&#93; The identifier for a group in the identity store.
#'
#' @keywords internal
#'
#' @rdname identitystore_delete_group
identitystore_delete_group <- function(IdentityStoreId, GroupId) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$delete_group_input(IdentityStoreId = IdentityStoreId, GroupId = GroupId)
  output <- .identitystore$delete_group_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$delete_group <- identitystore_delete_group

#' Delete a membership within a group given MembershipId
#'
#' @description
#' Delete a membership within a group given `MembershipId`.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_delete_group_membership/](https://www.paws-r-sdk.com/docs/identitystore_delete_group_membership/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param MembershipId &#91;required&#93; The identifier for a `GroupMembership` in an identity store.
#'
#' @keywords internal
#'
#' @rdname identitystore_delete_group_membership
identitystore_delete_group_membership <- function(IdentityStoreId, MembershipId) {
  op <- new_operation(
    name = "DeleteGroupMembership",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$delete_group_membership_input(IdentityStoreId = IdentityStoreId, MembershipId = MembershipId)
  output <- .identitystore$delete_group_membership_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$delete_group_membership <- identitystore_delete_group_membership

#' Deletes a user within an identity store given UserId
#'
#' @description
#' Deletes a user within an identity store given `UserId`.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_delete_user/](https://www.paws-r-sdk.com/docs/identitystore_delete_user/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param UserId &#91;required&#93; The identifier for a user in the identity store.
#'
#' @keywords internal
#'
#' @rdname identitystore_delete_user
identitystore_delete_user <- function(IdentityStoreId, UserId) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$delete_user_input(IdentityStoreId = IdentityStoreId, UserId = UserId)
  output <- .identitystore$delete_user_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$delete_user <- identitystore_delete_user

#' Retrieves the group metadata and attributes from GroupId in an identity
#' store
#'
#' @description
#' Retrieves the group metadata and attributes from `GroupId` in an identity store.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_describe_group/](https://www.paws-r-sdk.com/docs/identitystore_describe_group/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store, such as
#' `d-1234567890`. In this example, `d-` is a fixed prefix, and
#' `1234567890` is a randomly generated string that contains numbers and
#' lower case letters. This value is generated at the time that a new
#' identity store is created.
#' @param GroupId &#91;required&#93; The identifier for a group in the identity store.
#'
#' @keywords internal
#'
#' @rdname identitystore_describe_group
identitystore_describe_group <- function(IdentityStoreId, GroupId) {
  op <- new_operation(
    name = "DescribeGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$describe_group_input(IdentityStoreId = IdentityStoreId, GroupId = GroupId)
  output <- .identitystore$describe_group_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$describe_group <- identitystore_describe_group

#' Retrieves membership metadata and attributes from MembershipId in an
#' identity store
#'
#' @description
#' Retrieves membership metadata and attributes from `MembershipId` in an identity store.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_describe_group_membership/](https://www.paws-r-sdk.com/docs/identitystore_describe_group_membership/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param MembershipId &#91;required&#93; The identifier for a `GroupMembership` in an identity store.
#'
#' @keywords internal
#'
#' @rdname identitystore_describe_group_membership
identitystore_describe_group_membership <- function(IdentityStoreId, MembershipId) {
  op <- new_operation(
    name = "DescribeGroupMembership",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$describe_group_membership_input(IdentityStoreId = IdentityStoreId, MembershipId = MembershipId)
  output <- .identitystore$describe_group_membership_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$describe_group_membership <- identitystore_describe_group_membership

#' Retrieves the user metadata and attributes from the UserId in an
#' identity store
#'
#' @description
#' Retrieves the user metadata and attributes from the `UserId` in an identity store.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_describe_user/](https://www.paws-r-sdk.com/docs/identitystore_describe_user/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store, such as
#' `d-1234567890`. In this example, `d-` is a fixed prefix, and
#' `1234567890` is a randomly generated string that contains numbers and
#' lower case letters. This value is generated at the time that a new
#' identity store is created.
#' @param UserId &#91;required&#93; The identifier for a user in the identity store.
#'
#' @keywords internal
#'
#' @rdname identitystore_describe_user
identitystore_describe_user <- function(IdentityStoreId, UserId) {
  op <- new_operation(
    name = "DescribeUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$describe_user_input(IdentityStoreId = IdentityStoreId, UserId = UserId)
  output <- .identitystore$describe_user_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$describe_user <- identitystore_describe_user

#' Retrieves GroupId in an identity store
#'
#' @description
#' Retrieves `GroupId` in an identity store.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_get_group_id/](https://www.paws-r-sdk.com/docs/identitystore_get_group_id/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param AlternateIdentifier &#91;required&#93; A unique identifier for a user or group that is not the primary
#' identifier. This value can be an identifier from an external identity
#' provider (IdP) that is associated with the user, the group, or a unique
#' attribute. For the unique attribute, the only valid path is
#' `displayName`.
#'
#' @keywords internal
#'
#' @rdname identitystore_get_group_id
identitystore_get_group_id <- function(IdentityStoreId, AlternateIdentifier) {
  op <- new_operation(
    name = "GetGroupId",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$get_group_id_input(IdentityStoreId = IdentityStoreId, AlternateIdentifier = AlternateIdentifier)
  output <- .identitystore$get_group_id_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$get_group_id <- identitystore_get_group_id

#' Retrieves the MembershipId in an identity store
#'
#' @description
#' Retrieves the `MembershipId` in an identity store.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_get_group_membership_id/](https://www.paws-r-sdk.com/docs/identitystore_get_group_membership_id/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param GroupId &#91;required&#93; The identifier for a group in the identity store.
#' @param MemberId &#91;required&#93; An object that contains the identifier of a group member. Setting the
#' `UserID` field to the specific identifier for a user indicates that the
#' user is a member of the group.
#'
#' @keywords internal
#'
#' @rdname identitystore_get_group_membership_id
identitystore_get_group_membership_id <- function(IdentityStoreId, GroupId, MemberId) {
  op <- new_operation(
    name = "GetGroupMembershipId",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$get_group_membership_id_input(IdentityStoreId = IdentityStoreId, GroupId = GroupId, MemberId = MemberId)
  output <- .identitystore$get_group_membership_id_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$get_group_membership_id <- identitystore_get_group_membership_id

#' Retrieves the UserId in an identity store
#'
#' @description
#' Retrieves the `UserId` in an identity store.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_get_user_id/](https://www.paws-r-sdk.com/docs/identitystore_get_user_id/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param AlternateIdentifier &#91;required&#93; A unique identifier for a user or group that is not the primary
#' identifier. This value can be an identifier from an external identity
#' provider (IdP) that is associated with the user, the group, or a unique
#' attribute. For the unique attribute, the only valid paths are `userName`
#' and `emails.value`.
#'
#' @keywords internal
#'
#' @rdname identitystore_get_user_id
identitystore_get_user_id <- function(IdentityStoreId, AlternateIdentifier) {
  op <- new_operation(
    name = "GetUserId",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$get_user_id_input(IdentityStoreId = IdentityStoreId, AlternateIdentifier = AlternateIdentifier)
  output <- .identitystore$get_user_id_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$get_user_id <- identitystore_get_user_id

#' Checks the user's membership in all requested groups and returns if the
#' member exists in all queried groups
#'
#' @description
#' Checks the user's membership in all requested groups and returns if the member exists in all queried groups.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_is_member_in_groups/](https://www.paws-r-sdk.com/docs/identitystore_is_member_in_groups/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param MemberId &#91;required&#93; An object containing the identifier of a group member.
#' @param GroupIds &#91;required&#93; A list of identifiers for groups in the identity store.
#'
#' @keywords internal
#'
#' @rdname identitystore_is_member_in_groups
identitystore_is_member_in_groups <- function(IdentityStoreId, MemberId, GroupIds) {
  op <- new_operation(
    name = "IsMemberInGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$is_member_in_groups_input(IdentityStoreId = IdentityStoreId, MemberId = MemberId, GroupIds = GroupIds)
  output <- .identitystore$is_member_in_groups_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$is_member_in_groups <- identitystore_is_member_in_groups

#' For the specified group in the specified identity store, returns the
#' list of all GroupMembership objects and returns results in paginated
#' form
#'
#' @description
#' For the specified group in the specified identity store, returns the list of all `GroupMembership` objects and returns results in paginated form.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_list_group_memberships/](https://www.paws-r-sdk.com/docs/identitystore_list_group_memberships/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param GroupId &#91;required&#93; The identifier for a group in the identity store.
#' @param MaxResults The maximum number of results to be returned per request. This parameter
#' is used in all `List` requests to specify how many results to return in
#' one page.
#' @param NextToken The pagination token used for the
#' [`list_users`][identitystore_list_users],
#' [`list_groups`][identitystore_list_groups] and
#' [`list_group_memberships`][identitystore_list_group_memberships] API
#' operations. This value is generated by the identity store service. It is
#' returned in the API response if the total results are more than the size
#' of one page. This token is also returned when it is used in the API
#' request to search for the next page.
#'
#' @keywords internal
#'
#' @rdname identitystore_list_group_memberships
identitystore_list_group_memberships <- function(IdentityStoreId, GroupId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGroupMemberships",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "GroupMemberships"),
    stream_api = FALSE
  )
  input <- .identitystore$list_group_memberships_input(IdentityStoreId = IdentityStoreId, GroupId = GroupId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .identitystore$list_group_memberships_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$list_group_memberships <- identitystore_list_group_memberships

#' For the specified member in the specified identity store, returns the
#' list of all GroupMembership objects and returns results in paginated
#' form
#'
#' @description
#' For the specified member in the specified identity store, returns the list of all `GroupMembership` objects and returns results in paginated form.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_list_group_memberships_for_member/](https://www.paws-r-sdk.com/docs/identitystore_list_group_memberships_for_member/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param MemberId &#91;required&#93; An object that contains the identifier of a group member. Setting the
#' `UserID` field to the specific identifier for a user indicates that the
#' user is a member of the group.
#' @param MaxResults The maximum number of results to be returned per request. This parameter
#' is used in the [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] requests to specify how many
#' results to return in one page. The length limit is 50 characters.
#' @param NextToken The pagination token used for the
#' [`list_users`][identitystore_list_users],
#' [`list_groups`][identitystore_list_groups], and
#' [`list_group_memberships`][identitystore_list_group_memberships] API
#' operations. This value is generated by the identity store service. It is
#' returned in the API response if the total results are more than the size
#' of one page. This token is also returned when it is used in the API
#' request to search for the next page.
#'
#' @keywords internal
#'
#' @rdname identitystore_list_group_memberships_for_member
identitystore_list_group_memberships_for_member <- function(IdentityStoreId, MemberId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGroupMembershipsForMember",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "GroupMemberships"),
    stream_api = FALSE
  )
  input <- .identitystore$list_group_memberships_for_member_input(IdentityStoreId = IdentityStoreId, MemberId = MemberId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .identitystore$list_group_memberships_for_member_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$list_group_memberships_for_member <- identitystore_list_group_memberships_for_member

#' Lists all groups in the identity store
#'
#' @description
#' Lists all groups in the identity store. Returns a paginated list of complete `Group` objects. Filtering for a `Group` by the `DisplayName` attribute is deprecated. Instead, use the [`get_group_id`][identitystore_get_group_id] API action.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_list_groups/](https://www.paws-r-sdk.com/docs/identitystore_list_groups/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store, such as
#' `d-1234567890`. In this example, `d-` is a fixed prefix, and
#' `1234567890` is a randomly generated string that contains numbers and
#' lower case letters. This value is generated at the time that a new
#' identity store is created.
#' @param MaxResults The maximum number of results to be returned per request. This parameter
#' is used in the [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] requests to specify how many
#' results to return in one page. The length limit is 50 characters.
#' @param NextToken The pagination token used for the
#' [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] API operations. This value is
#' generated by the identity store service. It is returned in the API
#' response if the total results are more than the size of one page. This
#' token is also returned when it is used in the API request to search for
#' the next page.
#' @param Filters A list of `Filter` objects, which is used in the
#' [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] requests.
#'
#' @keywords internal
#'
#' @rdname identitystore_list_groups
identitystore_list_groups <- function(IdentityStoreId, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Groups"),
    stream_api = FALSE
  )
  input <- .identitystore$list_groups_input(IdentityStoreId = IdentityStoreId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .identitystore$list_groups_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$list_groups <- identitystore_list_groups

#' Lists all users in the identity store
#'
#' @description
#' Lists all users in the identity store. Returns a paginated list of complete `User` objects. Filtering for a `User` by the `UserName` attribute is deprecated. Instead, use the [`get_user_id`][identitystore_get_user_id] API action.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_list_users/](https://www.paws-r-sdk.com/docs/identitystore_list_users/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store, such as
#' `d-1234567890`. In this example, `d-` is a fixed prefix, and
#' `1234567890` is a randomly generated string that contains numbers and
#' lower case letters. This value is generated at the time that a new
#' identity store is created.
#' @param MaxResults The maximum number of results to be returned per request. This parameter
#' is used in the [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] requests to specify how many
#' results to return in one page. The length limit is 50 characters.
#' @param NextToken The pagination token used for the
#' [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] API operations. This value is
#' generated by the identity store service. It is returned in the API
#' response if the total results are more than the size of one page. This
#' token is also returned when it is used in the API request to search for
#' the next page.
#' @param Filters A list of `Filter` objects, which is used in the
#' [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] requests.
#'
#' @keywords internal
#'
#' @rdname identitystore_list_users
identitystore_list_users <- function(IdentityStoreId, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Users"),
    stream_api = FALSE
  )
  input <- .identitystore$list_users_input(IdentityStoreId = IdentityStoreId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .identitystore$list_users_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$list_users <- identitystore_list_users

#' For the specified group in the specified identity store, updates the
#' group metadata and attributes
#'
#' @description
#' For the specified group in the specified identity store, updates the group metadata and attributes.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_update_group/](https://www.paws-r-sdk.com/docs/identitystore_update_group/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param GroupId &#91;required&#93; The identifier for a group in the identity store.
#' @param Operations &#91;required&#93; A list of `AttributeOperation` objects to apply to the requested group.
#' These operations might add, replace, or remove an attribute.
#'
#' @keywords internal
#'
#' @rdname identitystore_update_group
identitystore_update_group <- function(IdentityStoreId, GroupId, Operations) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$update_group_input(IdentityStoreId = IdentityStoreId, GroupId = GroupId, Operations = Operations)
  output <- .identitystore$update_group_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$update_group <- identitystore_update_group

#' For the specified user in the specified identity store, updates the user
#' metadata and attributes
#'
#' @description
#' For the specified user in the specified identity store, updates the user metadata and attributes.
#'
#' See [https://www.paws-r-sdk.com/docs/identitystore_update_user/](https://www.paws-r-sdk.com/docs/identitystore_update_user/) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store.
#' @param UserId &#91;required&#93; The identifier for a user in the identity store.
#' @param Operations &#91;required&#93; A list of `AttributeOperation` objects to apply to the requested user.
#' These operations might add, replace, or remove an attribute.
#'
#' @keywords internal
#'
#' @rdname identitystore_update_user
identitystore_update_user <- function(IdentityStoreId, UserId, Operations) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .identitystore$update_user_input(IdentityStoreId = IdentityStoreId, UserId = UserId, Operations = Operations)
  output <- .identitystore$update_user_output()
  config <- get_config()
  svc <- .identitystore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$update_user <- identitystore_update_user
