# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sso_service.R
NULL

#' Returns the STS short-term credentials for a given role name that is
#' assigned to the user
#'
#' @description
#' Returns the STS short-term credentials for a given role name that is assigned to the user.
#'
#' See [https://www.paws-r-sdk.com/docs/sso_get_role_credentials/](https://www.paws-r-sdk.com/docs/sso_get_role_credentials/) for full documentation.
#'
#' @param roleName &#91;required&#93; The friendly name of the role that is assigned to the user.
#' @param accountId &#91;required&#93; The identifier for the AWS account that is assigned to the user.
#' @param accessToken &#91;required&#93; The token issued by the `CreateToken` API call. For more information,
#' see
#' [CreateToken](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html)
#' in the *IAM Identity Center OIDC API Reference Guide*.
#'
#' @keywords internal
#'
#' @rdname sso_get_role_credentials
sso_get_role_credentials <- function(roleName, accountId, accessToken) {
  op <- new_operation(
    name = "GetRoleCredentials",
    http_method = "GET",
    http_path = "/federation/credentials",
    paginator = list()
  )
  input <- .sso$get_role_credentials_input(roleName = roleName, accountId = accountId, accessToken = accessToken)
  output <- .sso$get_role_credentials_output()
  config <- get_config()
  svc <- .sso$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sso$operations$get_role_credentials <- sso_get_role_credentials

#' Lists all roles that are assigned to the user for a given AWS account
#'
#' @description
#' Lists all roles that are assigned to the user for a given AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/sso_list_account_roles/](https://www.paws-r-sdk.com/docs/sso_list_account_roles/) for full documentation.
#'
#' @param nextToken The page token from the previous response output when you request
#' subsequent pages.
#' @param maxResults The number of items that clients can request per page.
#' @param accessToken &#91;required&#93; The token issued by the `CreateToken` API call. For more information,
#' see
#' [CreateToken](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html)
#' in the *IAM Identity Center OIDC API Reference Guide*.
#' @param accountId &#91;required&#93; The identifier for the AWS account that is assigned to the user.
#'
#' @keywords internal
#'
#' @rdname sso_list_account_roles
sso_list_account_roles <- function(nextToken = NULL, maxResults = NULL, accessToken, accountId) {
  op <- new_operation(
    name = "ListAccountRoles",
    http_method = "GET",
    http_path = "/assignment/roles",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "roleList")
  )
  input <- .sso$list_account_roles_input(nextToken = nextToken, maxResults = maxResults, accessToken = accessToken, accountId = accountId)
  output <- .sso$list_account_roles_output()
  config <- get_config()
  svc <- .sso$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sso$operations$list_account_roles <- sso_list_account_roles

#' Lists all AWS accounts assigned to the user
#'
#' @description
#' Lists all AWS accounts assigned to the user. These AWS accounts are assigned by the administrator of the account. For more information, see [Assign User Access](https://docs.aws.amazon.com/singlesignon/latest/userguide/useraccess.html#assignusers) in the *IAM Identity Center User Guide*. This operation returns a paginated response.
#'
#' See [https://www.paws-r-sdk.com/docs/sso_list_accounts/](https://www.paws-r-sdk.com/docs/sso_list_accounts/) for full documentation.
#'
#' @param nextToken (Optional) When requesting subsequent pages, this is the page token from
#' the previous response output.
#' @param maxResults This is the number of items clients can request per page.
#' @param accessToken &#91;required&#93; The token issued by the `CreateToken` API call. For more information,
#' see
#' [CreateToken](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html)
#' in the *IAM Identity Center OIDC API Reference Guide*.
#'
#' @keywords internal
#'
#' @rdname sso_list_accounts
sso_list_accounts <- function(nextToken = NULL, maxResults = NULL, accessToken) {
  op <- new_operation(
    name = "ListAccounts",
    http_method = "GET",
    http_path = "/assignment/accounts",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "accountList")
  )
  input <- .sso$list_accounts_input(nextToken = nextToken, maxResults = maxResults, accessToken = accessToken)
  output <- .sso$list_accounts_output()
  config <- get_config()
  svc <- .sso$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sso$operations$list_accounts <- sso_list_accounts

#' Removes the locally stored SSO tokens from the client-side cache and
#' sends an API call to the IAM Identity Center service to invalidate the
#' corresponding server-side IAM Identity Center sign in session
#'
#' @description
#' Removes the locally stored SSO tokens from the client-side cache and sends an API call to the IAM Identity Center service to invalidate the corresponding server-side IAM Identity Center sign in session.
#'
#' See [https://www.paws-r-sdk.com/docs/sso_logout/](https://www.paws-r-sdk.com/docs/sso_logout/) for full documentation.
#'
#' @param accessToken &#91;required&#93; The token issued by the `CreateToken` API call. For more information,
#' see
#' [CreateToken](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html)
#' in the *IAM Identity Center OIDC API Reference Guide*.
#'
#' @keywords internal
#'
#' @rdname sso_logout
sso_logout <- function(accessToken) {
  op <- new_operation(
    name = "Logout",
    http_method = "POST",
    http_path = "/logout",
    paginator = list()
  )
  input <- .sso$logout_input(accessToken = accessToken)
  output <- .sso$logout_output()
  config <- get_config()
  svc <- .sso$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sso$operations$logout <- sso_logout
