% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssooidc_operations.R
\name{ssooidc_create_token}
\alias{ssooidc_create_token}
\title{Creates and returns an access token for the authorized client}
\usage{
ssooidc_create_token(
  clientId,
  clientSecret,
  grantType,
  deviceCode = NULL,
  code = NULL,
  refreshToken = NULL,
  scope = NULL,
  redirectUri = NULL
)
}
\arguments{
\item{clientId}{[required] The unique identifier string for each client. This value should come
from the persisted result of the
\code{\link[=ssooidc_register_client]{register_client}} API.}

\item{clientSecret}{[required] A secret string generated for the client. This value should come from
the persisted result of the \code{\link[=ssooidc_register_client]{register_client}}
API.}

\item{grantType}{[required] Supports grant types for the authorization code, refresh token, and
device code request. For device code requests, specify the following
value:

\code{urn:ietf:params:oauth:grant-type:device_code }

For information about how to obtain the device code, see the
\code{\link[=ssooidc_start_device_authorization]{start_device_authorization}}
topic.}

\item{deviceCode}{Used only when calling this API for the device code grant type. This
short-term code is used to identify this authentication attempt. This
should come from an in-memory reference to the result of the
\code{\link[=ssooidc_start_device_authorization]{start_device_authorization}} API.}

\item{code}{The authorization code received from the authorization service. This
parameter is required to perform an authorization grant request to get
access to a token.}

\item{refreshToken}{Currently, \code{refreshToken} is not yet implemented and is not supported.
For more information about the features and limitations of the current
IAM Identity Center OIDC implementation, see \emph{Considerations for Using
this Guide} in the \href{https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html}{IAM Identity Center OIDC API Reference}.

The token used to obtain an access token in the event that the access
token is invalid or expired.}

\item{scope}{The list of scopes that is defined by the client. Upon authorization,
this list is used to restrict permissions when granting an access token.}

\item{redirectUri}{The location of the application that will receive the authorization
code. Users authorize the service to send the request to this location.}
}
\description{
Creates and returns an access token for the authorized client. The access token issued will be used to fetch short-term credentials for the assigned roles in the AWS account.

See \url{https://www.paws-r-sdk.com/docs/ssooidc_create_token/} for full documentation.
}
\keyword{internal}
