% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_get_resource_policies}
\alias{ram_get_resource_policies}
\title{Retrieves the resource policies for the specified resources that you own
and have shared}
\usage{
ram_get_resource_policies(
  resourceArns,
  principal = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{resourceArns}{[required] Specifies the \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
of the resources whose policies you want to retrieve.}

\item{principal}{Specifies the principal.}

\item{nextToken}{Specifies that you want to receive the next page of results. Valid only
if you received a \code{NextToken} response in the previous request. If you
did, it indicates that more output is available. Set this parameter to
the value provided by the previous call's \code{NextToken} response to
request the next page of results.}

\item{maxResults}{Specifies the total number of results that you want included on each
page of the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the number you specify, the \code{NextToken} response element is
returned with a value (not null). Include the specified value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that the service might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}
}
\description{
Retrieves the resource policies for the specified resources that you own and have shared.

See \url{https://paws-r.github.io/docs/ram/get_resource_policies.html} for full documentation.
}
\keyword{internal}
