% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_list_users}
\alias{cognitoidentityprovider_list_users}
\title{Lists the users in the Amazon Cognito user pool}
\usage{
cognitoidentityprovider_list_users(
  UserPoolId,
  AttributesToGet = NULL,
  Limit = NULL,
  PaginationToken = NULL,
  Filter = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool on which the search should be
performed.}

\item{AttributesToGet}{An array of strings, where each string is the name of a user attribute
to be returned for each user in the search results. If the array is
null, all attributes are returned.}

\item{Limit}{Maximum number of users to be returned.}

\item{PaginationToken}{An identifier that was returned from the previous call to this
operation, which can be used to return the next set of items in the
list.}

\item{Filter}{A filter string of the form "\emph{AttributeName} \emph{Filter-Type}
"\emph{AttributeValue}"". Quotation marks within the filter string must be
escaped using the backslash (\\) character. For example, "\code{family_name}
= \\"Reddy\\"".
\itemize{
\item \emph{AttributeName}: The name of the attribute to search for. You can
only search for one attribute at a time.
\item \emph{Filter-Type}: For an exact match, use =, for example, "\code{given_name}
= \\"Jon\\"". For a prefix ("starts with") match, use ^=, for
example, "\code{given_name} ^= \\"Jon\\"".
\item \emph{AttributeValue}: The attribute value that must be matched for each
user.
}

If the filter string is empty,
\code{\link[=cognitoidentityprovider_list_users]{list_users}} returns all users in
the user pool.

You can only search for the following standard attributes:
\itemize{
\item \code{username} (case-sensitive)
\item \code{email}
\item \code{phone_number}
\item \code{name}
\item \code{given_name}
\item \code{family_name}
\item \code{preferred_username}
\item \code{cognito:user_status} (called \strong{Status} in the Console)
(case-insensitive)
\item \verb{status (called Enabled in the Console) (case-sensitive)}
\item \code{sub}
}

Custom attributes aren't searchable.

You can also list users with a client-side filter. The server-side
filter matches no more than one attribute. For an advanced search, use a
client-side filter with the \code{--query} parameter of the \code{list-users}
action in the CLI. When you use a client-side filter, ListUsers returns
a paginated list of zero or more users. You can receive multiple pages
in a row with zero results. Repeat the query with each pagination token
that is returned until you receive a null pagination token value, and
then review the combined result.

For more information about server-side and client-side filtering, see
\href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html}{FilteringCLI output}
in the \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html}{Command Line Interface User Guide}.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api}{Searching for Users Using the ListUsers API}
and \href{https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples}{Examples of Using the ListUsers API}
in the \emph{Amazon Cognito Developer Guide}.}
}
\description{
Lists the users in the Amazon Cognito user pool.

See \url{https://paws-r.github.io/docs/cognitoidentityprovider/list_users.html} for full documentation.
}
\keyword{internal}
