% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_get_web_acl}
\alias{wafregional_get_web_acl}
\title{This is AWS WAF CLASSIC documentation}
\usage{
wafregional_get_web_acl(WebACLId)
}
\arguments{
\item{WebACLId}{[required] The \code{WebACLId} of the WebACL that you want to get. \code{WebACLId} is
returned by CreateWebACL and by ListWebACLs.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.
}
\details{
\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Returns the WebACL that is specified by \code{WebACLId}.
}
\section{Request syntax}{
\preformatted{svc$get_web_acl(
  WebACLId = "string"
)
}
}

\examples{
\dontrun{
# The following example returns the details of a web ACL with the ID
# createwebacl-1472061481310.
svc$get_web_acl(
  WebACLId = "createwebacl-1472061481310"
)
}

}
\keyword{internal}
