% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_list_secret_version_ids}
\alias{secretsmanager_list_secret_version_ids}
\title{Lists all of the versions attached to the specified secret}
\usage{
secretsmanager_list_secret_version_ids(SecretId, MaxResults, NextToken,
  IncludeDeprecated)
}
\arguments{
\item{SecretId}{[required] The identifier for the secret containing the versions you want to list.
You can specify either the Amazon Resource Name (ARN) or the friendly
name of the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too---for example, if you
don't include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you're
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don't create secret names
ending with a hyphen followed by six characters.

If you specify an incomplete ARN without the random suffix, and instead
provide the \'friendly name\', you \emph{must} not include the random suffix.
If you do include the random suffix added by Secrets Manager, you
receive either a \emph{ResourceNotFoundException} or an
\emph{AccessDeniedException} error, depending on your permissions.}

\item{MaxResults}{(Optional) Limits the number of results you want to include in the
response. If you don\'t include this parameter, it defaults to a value
that\'s specific to the operation. If additional items exist beyond the
maximum you specify, the \code{NextToken} response element is present and has
a value (isn\'t null). Include that value as the \code{NextToken} request
parameter in the next call to the operation to get the next part of the
results. Note that Secrets Manager might return fewer results than the
maximum even when there are more results available. You should check
\code{NextToken} after every operation to ensure that you receive all of the
results.}

\item{NextToken}{(Optional) Use this parameter in a request if you receive a \code{NextToken}
response in a previous request indicating there\'s more output
available. In a subsequent call, set it to the value of the previous
call \code{NextToken} response to indicate where the output should continue
from.}

\item{IncludeDeprecated}{(Optional) Specifies that you want the results to include versions that
do not have any staging labels attached to them. Such versions are
considered deprecated and are subject to deletion by Secrets Manager as
needed.}
}
\description{
Lists all of the versions attached to the specified secret. The output
does not include the \code{SecretString} or \code{SecretBinary} fields. By
default, the list includes only versions that have at least one staging
label in \code{VersionStage} attached.
}
\details{
Always check the \code{NextToken} response parameter when calling any of the
\verb{List*} operations. These operations can occasionally return an empty or
shorter than expected list of results even when there more results
become available. When this happens, the \code{NextToken} response parameter
contains a value to pass to the next call to the same API to request the
next part of the list.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:ListSecretVersionIds
}

\strong{Related operations}
\itemize{
\item To list the secrets in an account, use ListSecrets.
}
}
\section{Request syntax}{
\preformatted{svc$list_secret_version_ids(
  SecretId = "string",
  MaxResults = 123,
  NextToken = "string",
  IncludeDeprecated = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# The following example shows how to retrieve a list of all of the
# versions of a secret, including those without any staging labels.
svc$list_secret_version_ids(
  IncludeDeprecated = TRUE,
  SecretId = "MyTestDatabaseSecret"
)
}

}
\keyword{internal}
