% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_remove_attributes_from_findings}
\alias{inspector_remove_attributes_from_findings}
\title{Removes entire attributes (key and value pairs) from the findings that
are specified by the ARNs of the findings where an attribute with the
specified key exists}
\usage{
inspector_remove_attributes_from_findings(findingArns, attributeKeys)
}
\arguments{
\item{findingArns}{[required] The ARNs that specify the findings that you want to remove attributes
from.}

\item{attributeKeys}{[required] The array of attribute keys that you want to remove from specified
findings.}
}
\description{
Removes entire attributes (key and value pairs) from the findings that
are specified by the ARNs of the findings where an attribute with the
specified key exists.
}
\section{Request syntax}{
\preformatted{svc$remove_attributes_from_findings(
  findingArns = list(
    "string"
  ),
  attributeKeys = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# Removes entire attributes (key and value pairs) from the findings that
# are specified by the ARNs of the findings where an attribute with the
# specified key exists.
svc$remove_attributes_from_findings(
  attributeKeys = list(
    "key=Example,value=example"
  ),
  findingArns = list(
    "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-8l1VIE0D/run/0-Z0..."
  )
)
}

}
\keyword{internal}
