% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_create_size_constraint_set}
\alias{waf_create_size_constraint_set}
\title{Creates a SizeConstraintSet}
\usage{
waf_create_size_constraint_set(Name, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description of the SizeConstraintSet. You can\'t
change \code{Name} after you create a \code{SizeConstraintSet}.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Creates a \code{SizeConstraintSet}. You then use UpdateSizeConstraintSet to
identify the part of a web request that you want AWS WAF to check for
length, such as the length of the \code{User-Agent} header or the length of
the query string. For example, you can create a \code{SizeConstraintSet} that
matches any requests that have a query string that is longer than 100
bytes. You can then configure AWS WAF to reject those requests.
}
\details{
To create and configure a \code{SizeConstraintSet}, perform the following
steps:
\enumerate{
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{CreateSizeConstraintSet} request.
\item Submit a \code{CreateSizeConstraintSet} request.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an \code{UpdateSizeConstraintSet} request.
\item Submit an UpdateSizeConstraintSet request to specify the part of the
request that you want AWS WAF to inspect (for example, the header or
the URI) and the value that you want AWS WAF to watch for.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_size_constraint_set(
  Name = "string",
  ChangeToken = "string"
)
}
}

\examples{
# The following example creates size constraint set named
# MySampleSizeConstraintSet.
\donttest{svc$create_size_constraint_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  Name = "MySampleSizeConstraintSet"
)}

}
\keyword{internal}
