% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_custom_key_store}
\alias{kms_create_custom_key_store}
\title{Creates a custom key store that is associated with an AWS CloudHSM
cluster that you own and manage}
\usage{
kms_create_custom_key_store(CustomKeyStoreName, CloudHsmClusterId,
  TrustAnchorCertificate, KeyStorePassword)
}
\arguments{
\item{CustomKeyStoreName}{[required] Specifies a friendly name for the custom key store. The name must be
unique in your AWS account.}

\item{CloudHsmClusterId}{[required] Identifies the AWS CloudHSM cluster for the custom key store. Enter the
cluster ID of any active AWS CloudHSM cluster that is not already
associated with a custom key store. To find the cluster ID, use the
\href{https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html}{DescribeClusters}
operation.}

\item{TrustAnchorCertificate}{[required] Enter the content of the trust anchor certificate for the cluster. This
is the content of the \code{customerCA.crt} file that you created when you
\href{https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html}{initialized the cluster}.}

\item{KeyStorePassword}{[required] Enter the password of the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser}{kmsuser crypto user (CU) account}
in the specified AWS CloudHSM cluster. AWS KMS logs into the cluster as
this user to manage key material on your behalf.

This parameter tells AWS KMS the \code{kmsuser} account password; it does not
change the password in the AWS CloudHSM cluster.}
}
\description{
Creates a \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store}
that is associated with an \href{https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html}{AWS CloudHSM cluster}
that you own and manage.
}
\details{
This operation is part of the \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{Custom Key Store feature}
feature in AWS KMS, which combines the convenience and extensive
integration of AWS KMS with the isolation and control of a single-tenant
key store.

Before you create the custom key store, you must assemble the required
elements, including an AWS CloudHSM cluster that fulfills the
requirements for a custom key store. For details about the required
elements, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore}{Assemble the Prerequisites}
in the \emph{AWS Key Management Service Developer Guide}.

When the operation completes successfully, it returns the ID of the new
custom key store. Before you can use your new custom key store, you need
to use the ConnectCustomKeyStore operation to connect the new key store
to its AWS CloudHSM cluster. Even if you are not going to use your
custom key store immediately, you might want to connect it to verify
that all settings are correct and then disconnect it until you are ready
to use it.

For help with failures, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html}{Troubleshooting a Custom Key Store}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_custom_key_store(
  CustomKeyStoreName = "string",
  CloudHsmClusterId = "string",
  TrustAnchorCertificate = "string",
  KeyStorePassword = "string"
)
}
}

\keyword{internal}
