% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_group}
\alias{iam_get_group}
\title{Returns a list of IAM users that are in the specified IAM group}
\usage{
iam_get_group(GroupName, Marker, MaxItems)
}
\arguments{
\item{GroupName}{[required] The name of the group.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\value{
A list with the following syntax:\preformatted{list(
  Group = list(
    Path = "string",
    GroupName = "string",
    GroupId = "string",
    Arn = "string",
    CreateDate = as.POSIXct(
      "2015-01-01"
    )
  ),
  Users = list(
    list(
      Path = "string",
      UserName = "string",
      UserId = "string",
      Arn = "string",
      CreateDate = as.POSIXct(
        "2015-01-01"
      ),
      PasswordLastUsed = as.POSIXct(
        "2015-01-01"
      ),
      PermissionsBoundary = list(
        PermissionsBoundaryType = "PermissionsBoundaryPolicy",
        PermissionsBoundaryArn = "string"
      ),
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  IsTruncated = TRUE|FALSE,
  Marker = "string"
)
}
}
\description{
Returns a list of IAM users that are in the specified IAM group. You can
paginate the results using the \code{MaxItems} and \code{Marker} parameters.
}
\section{Request syntax}{
\preformatted{svc$get_group(
  GroupName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
