% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_get_identity_provider_by_identifier}
\alias{cognitoidentityprovider_get_identity_provider_by_identifier}
\title{Gets the specified identity provider}
\usage{
cognitoidentityprovider_get_identity_provider_by_identifier(UserPoolId,
  IdpIdentifier)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{IdpIdentifier}{[required] The identity provider ID.}
}
\value{
A list with the following syntax:\preformatted{list(
  IdentityProvider = list(
    UserPoolId = "string",
    ProviderName = "string",
    ProviderType = "SAML"|"Facebook"|"Google"|"LoginWithAmazon"|"SignInWithApple"|"OIDC",
    ProviderDetails = list(
      "string"
    ),
    AttributeMapping = list(
      "string"
    ),
    IdpIdentifiers = list(
      "string"
    ),
    LastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    CreationDate = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Gets the specified identity provider.
}
\section{Request syntax}{
\preformatted{svc$get_identity_provider_by_identifier(
  UserPoolId = "string",
  IdpIdentifier = "string"
)
}
}

\keyword{internal}
