% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_sql_injection_match_set}
\alias{wafregional_create_sql_injection_match_set}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_create_sql_injection_match_set(Name, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description for the SqlInjectionMatchSet that you're
creating. You can't change \code{Name} after you create the
\code{SqlInjectionMatchSet}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=wafregional_get_change_token]{get_change_token}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  SqlInjectionMatchSet = list(
    SqlInjectionMatchSetId = "string",
    Name = "string",
    SqlInjectionMatchTuples = list(
      list(
        FieldToMatch = list(
          Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
          Data = "string"
        ),
        TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE"
      )
    )
  ),
  ChangeToken = "string"
)
}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Creates a SqlInjectionMatchSet, which you use to allow, block, or count
requests that contain snippets of SQL code in a specified part of web
requests. AWS WAF searches for character sequences that are likely to be
malicious strings.

To create and configure a \code{SqlInjectionMatchSet}, perform the following
steps:
\enumerate{
\item Use \code{\link[=wafregional_get_change_token]{get_change_token}} to get the
change token that you provide in the \code{ChangeToken} parameter of a
\code{\link[=wafregional_create_sql_injection_match_set]{create_sql_injection_match_set}}
request.
\item Submit a
\code{\link[=wafregional_create_sql_injection_match_set]{create_sql_injection_match_set}}
request.
\item Use \code{\link[=wafregional_get_change_token]{get_change_token}} to get the
change token that you provide in the \code{ChangeToken} parameter of an
\code{\link[=wafregional_update_sql_injection_match_set]{update_sql_injection_match_set}}
request.
\item Submit an
\code{\link[=wafregional_update_sql_injection_match_set]{update_sql_injection_match_set}}
request to specify the parts of web requests in which you want to
allow, block, or count malicious SQL code.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_sql_injection_match_set(
  Name = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example creates a SQL injection match set named
# MySQLInjectionMatchSet.
svc$create_sql_injection_match_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  Name = "MySQLInjectionMatchSet"
)
}

}
\keyword{internal}
