% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_saml_provider}
\alias{iam_update_saml_provider}
\title{Updates the metadata document for an existing SAML provider resource
object}
\usage{
iam_update_saml_provider(SAMLMetadataDocument, SAMLProviderArn)
}
\arguments{
\item{SAMLMetadataDocument}{[required] An XML document generated by an identity provider (IdP) that supports
SAML 2.0. The document includes the issuer's name, expiration
information, and keys that can be used to validate the SAML
authentication response (assertions) that are received from the IdP. You
must generate the metadata document using the identity management
software that is used as your organization's IdP.}

\item{SAMLProviderArn}{[required] The Amazon Resource Name (ARN) of the SAML provider to update.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}
}
\value{
A list with the following syntax:\preformatted{list(
  SAMLProviderArn = "string"
)
}
}
\description{
Updates the metadata document for an existing SAML provider resource
object.

This operation requires \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4}.
}
\section{Request syntax}{
\preformatted{svc$update_saml_provider(
  SAMLMetadataDocument = "string",
  SAMLProviderArn = "string"
)
}
}

\keyword{internal}
