% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_user_pool_domain}
\alias{cognitoidentityprovider_update_user_pool_domain}
\title{Updates the Secure Sockets Layer (SSL) certificate for the custom domain
for your user pool}
\usage{
cognitoidentityprovider_update_user_pool_domain(Domain, UserPoolId,
  CustomDomainConfig)
}
\arguments{
\item{Domain}{[required] The domain name for the custom domain that hosts the sign-up and sign-in
pages for your application. For example: \code{auth.example.com}.

This string can include only lowercase letters, numbers, and hyphens. Do
not use a hyphen for the first or last character. Use periods to
separate subdomain names.}

\item{UserPoolId}{[required] The ID of the user pool that is associated with the custom domain that
you are updating the certificate for.}

\item{CustomDomainConfig}{[required] The configuration for a custom domain that hosts the sign-up and sign-in
pages for your application. Use this object to specify an SSL
certificate that is managed by ACM.}
}
\value{
A list with the following syntax:\preformatted{list(
  CloudFrontDomain = "string"
)
}
}
\description{
Updates the Secure Sockets Layer (SSL) certificate for the custom domain
for your user pool.

You can use this operation to provide the Amazon Resource Name (ARN) of
a new certificate to Amazon Cognito. You cannot use it to change the
domain for a user pool.

A custom domain is used to host the Amazon Cognito hosted UI, which
provides sign-up and sign-in pages for your application. When you set up
a custom domain, you provide a certificate that you manage with AWS
Certificate Manager (ACM). When necessary, you can use this operation to
change the certificate that you applied to your custom domain.

Usually, this is unnecessary following routine certificate renewal with
ACM. When you renew your existing certificate in ACM, the ARN for your
certificate remains the same, and your custom domain uses the new
certificate automatically.

However, if you replace your existing certificate with a new one, ACM
gives the new certificate a new ARN. To apply the new certificate to
your custom domain, you must provide this ARN to Amazon Cognito.

When you add your new certificate in ACM, you must choose US East (N.
Virginia) as the AWS Region.

After you submit your request, Amazon Cognito requires up to 1 hour to
distribute your new certificate to your custom domain.

For more information about adding a custom domain to your user pool, see
\href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html}{Using Your Own Domain for the Hosted UI}.
}
\section{Request syntax}{
\preformatted{svc$update_user_pool_domain(
  Domain = "string",
  UserPoolId = "string",
  CustomDomainConfig = list(
    CertificateArn = "string"
  )
)
}
}

\keyword{internal}
