# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include elb_service.R
NULL

#' Adds the specified tags to the specified load balancer
#'
#' @description
#' Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_add_tags/](https://www.paws-r-sdk.com/docs/elb_add_tags/) for full documentation.
#'
#' @param LoadBalancerNames &#91;required&#93; The name of the load balancer. You can specify one load balancer only.
#' @param Tags &#91;required&#93; The tags.
#'
#' @keywords internal
#'
#' @rdname elb_add_tags
elb_add_tags <- function(LoadBalancerNames, Tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$add_tags_input(LoadBalancerNames = LoadBalancerNames, Tags = Tags)
  output <- .elb$add_tags_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$add_tags <- elb_add_tags

#' Associates one or more security groups with your load balancer in a
#' virtual private cloud (VPC)
#'
#' @description
#' Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_apply_security_groups_to_load_balancer/](https://www.paws-r-sdk.com/docs/elb_apply_security_groups_to_load_balancer/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param SecurityGroups &#91;required&#93; The IDs of the security groups to associate with the load balancer. Note
#' that you cannot specify the name of the security group.
#'
#' @keywords internal
#'
#' @rdname elb_apply_security_groups_to_load_balancer
elb_apply_security_groups_to_load_balancer <- function(LoadBalancerName, SecurityGroups) {
  op <- new_operation(
    name = "ApplySecurityGroupsToLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$apply_security_groups_to_load_balancer_input(LoadBalancerName = LoadBalancerName, SecurityGroups = SecurityGroups)
  output <- .elb$apply_security_groups_to_load_balancer_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$apply_security_groups_to_load_balancer <- elb_apply_security_groups_to_load_balancer

#' Adds one or more subnets to the set of configured subnets for the
#' specified load balancer
#'
#' @description
#' Adds one or more subnets to the set of configured subnets for the specified load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_attach_load_balancer_to_subnets/](https://www.paws-r-sdk.com/docs/elb_attach_load_balancer_to_subnets/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Subnets &#91;required&#93; The IDs of the subnets to add. You can add only one subnet per
#' Availability Zone.
#'
#' @keywords internal
#'
#' @rdname elb_attach_load_balancer_to_subnets
elb_attach_load_balancer_to_subnets <- function(LoadBalancerName, Subnets) {
  op <- new_operation(
    name = "AttachLoadBalancerToSubnets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$attach_load_balancer_to_subnets_input(LoadBalancerName = LoadBalancerName, Subnets = Subnets)
  output <- .elb$attach_load_balancer_to_subnets_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$attach_load_balancer_to_subnets <- elb_attach_load_balancer_to_subnets

#' Specifies the health check settings to use when evaluating the health
#' state of your EC2 instances
#'
#' @description
#' Specifies the health check settings to use when evaluating the health state of your EC2 instances.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_configure_health_check/](https://www.paws-r-sdk.com/docs/elb_configure_health_check/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param HealthCheck &#91;required&#93; The configuration information.
#'
#' @keywords internal
#'
#' @rdname elb_configure_health_check
elb_configure_health_check <- function(LoadBalancerName, HealthCheck) {
  op <- new_operation(
    name = "ConfigureHealthCheck",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$configure_health_check_input(LoadBalancerName = LoadBalancerName, HealthCheck = HealthCheck)
  output <- .elb$configure_health_check_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$configure_health_check <- elb_configure_health_check

#' Generates a stickiness policy with sticky session lifetimes that follow
#' that of an application-generated cookie
#'
#' @description
#' Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_create_app_cookie_stickiness_policy/](https://www.paws-r-sdk.com/docs/elb_create_app_cookie_stickiness_policy/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param PolicyName &#91;required&#93; The name of the policy being created. Policy names must consist of
#' alphanumeric characters and dashes (-). This name must be unique within
#' the set of policies for this load balancer.
#' @param CookieName &#91;required&#93; The name of the application cookie used for stickiness.
#'
#' @keywords internal
#'
#' @rdname elb_create_app_cookie_stickiness_policy
elb_create_app_cookie_stickiness_policy <- function(LoadBalancerName, PolicyName, CookieName) {
  op <- new_operation(
    name = "CreateAppCookieStickinessPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$create_app_cookie_stickiness_policy_input(LoadBalancerName = LoadBalancerName, PolicyName = PolicyName, CookieName = CookieName)
  output <- .elb$create_app_cookie_stickiness_policy_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_app_cookie_stickiness_policy <- elb_create_app_cookie_stickiness_policy

#' Generates a stickiness policy with sticky session lifetimes controlled
#' by the lifetime of the browser (user-agent) or a specified expiration
#' period
#'
#' @description
#' Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_create_lb_cookie_stickiness_policy/](https://www.paws-r-sdk.com/docs/elb_create_lb_cookie_stickiness_policy/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param PolicyName &#91;required&#93; The name of the policy being created. Policy names must consist of
#' alphanumeric characters and dashes (-). This name must be unique within
#' the set of policies for this load balancer.
#' @param CookieExpirationPeriod The time period, in seconds, after which the cookie should be considered
#' stale. If you do not specify this parameter, the default value is 0,
#' which indicates that the sticky session should last for the duration of
#' the browser session.
#'
#' @keywords internal
#'
#' @rdname elb_create_lb_cookie_stickiness_policy
elb_create_lb_cookie_stickiness_policy <- function(LoadBalancerName, PolicyName, CookieExpirationPeriod = NULL) {
  op <- new_operation(
    name = "CreateLBCookieStickinessPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$create_lb_cookie_stickiness_policy_input(LoadBalancerName = LoadBalancerName, PolicyName = PolicyName, CookieExpirationPeriod = CookieExpirationPeriod)
  output <- .elb$create_lb_cookie_stickiness_policy_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_lb_cookie_stickiness_policy <- elb_create_lb_cookie_stickiness_policy

#' Creates a Classic Load Balancer
#'
#' @description
#' Creates a Classic Load Balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_create_load_balancer/](https://www.paws-r-sdk.com/docs/elb_create_load_balancer/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' 
#' This name must be unique within your set of load balancers for the
#' region, must have a maximum of 32 characters, must contain only
#' alphanumeric characters or hyphens, and cannot begin or end with a
#' hyphen.
#' @param Listeners &#91;required&#93; The listeners.
#' 
#' For more information, see [Listeners for Your Classic Load
#' Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html)
#' in the *Classic Load Balancers Guide*.
#' @param AvailabilityZones One or more Availability Zones from the same region as the load
#' balancer.
#' 
#' You must specify at least one Availability Zone.
#' 
#' You can add more Availability Zones after you create the load balancer
#' using
#' [`enable_availability_zones_for_load_balancer`][elb_enable_availability_zones_for_load_balancer].
#' @param Subnets The IDs of the subnets in your VPC to attach to the load balancer.
#' Specify one subnet per Availability Zone specified in
#' `AvailabilityZones`.
#' @param SecurityGroups The IDs of the security groups to assign to the load balancer.
#' @param Scheme The type of a load balancer. Valid only for load balancers in a VPC.
#' 
#' By default, Elastic Load Balancing creates an Internet-facing load
#' balancer with a DNS name that resolves to public IP addresses. For more
#' information about Internet-facing and Internal load balancers, see [Load
#' Balancer
#' Scheme](https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme)
#' in the *Elastic Load Balancing User Guide*.
#' 
#' Specify `internal` to create a load balancer with a DNS name that
#' resolves to private IP addresses.
#' @param Tags A list of tags to assign to the load balancer.
#' 
#' For more information about tagging your load balancer, see [Tag Your
#' Classic Load
#' Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @keywords internal
#'
#' @rdname elb_create_load_balancer
elb_create_load_balancer <- function(LoadBalancerName, Listeners, AvailabilityZones = NULL, Subnets = NULL, SecurityGroups = NULL, Scheme = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$create_load_balancer_input(LoadBalancerName = LoadBalancerName, Listeners = Listeners, AvailabilityZones = AvailabilityZones, Subnets = Subnets, SecurityGroups = SecurityGroups, Scheme = Scheme, Tags = Tags)
  output <- .elb$create_load_balancer_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_load_balancer <- elb_create_load_balancer

#' Creates one or more listeners for the specified load balancer
#'
#' @description
#' Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_create_load_balancer_listeners/](https://www.paws-r-sdk.com/docs/elb_create_load_balancer_listeners/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Listeners &#91;required&#93; The listeners.
#'
#' @keywords internal
#'
#' @rdname elb_create_load_balancer_listeners
elb_create_load_balancer_listeners <- function(LoadBalancerName, Listeners) {
  op <- new_operation(
    name = "CreateLoadBalancerListeners",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$create_load_balancer_listeners_input(LoadBalancerName = LoadBalancerName, Listeners = Listeners)
  output <- .elb$create_load_balancer_listeners_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_load_balancer_listeners <- elb_create_load_balancer_listeners

#' Creates a policy with the specified attributes for the specified load
#' balancer
#'
#' @description
#' Creates a policy with the specified attributes for the specified load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_create_load_balancer_policy/](https://www.paws-r-sdk.com/docs/elb_create_load_balancer_policy/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param PolicyName &#91;required&#93; The name of the load balancer policy to be created. This name must be
#' unique within the set of policies for this load balancer.
#' @param PolicyTypeName &#91;required&#93; The name of the base policy type. To get the list of policy types, use
#' [`describe_load_balancer_policy_types`][elb_describe_load_balancer_policy_types].
#' @param PolicyAttributes The policy attributes.
#'
#' @keywords internal
#'
#' @rdname elb_create_load_balancer_policy
elb_create_load_balancer_policy <- function(LoadBalancerName, PolicyName, PolicyTypeName, PolicyAttributes = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancerPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$create_load_balancer_policy_input(LoadBalancerName = LoadBalancerName, PolicyName = PolicyName, PolicyTypeName = PolicyTypeName, PolicyAttributes = PolicyAttributes)
  output <- .elb$create_load_balancer_policy_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_load_balancer_policy <- elb_create_load_balancer_policy

#' Deletes the specified load balancer
#'
#' @description
#' Deletes the specified load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_delete_load_balancer/](https://www.paws-r-sdk.com/docs/elb_delete_load_balancer/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#'
#' @keywords internal
#'
#' @rdname elb_delete_load_balancer
elb_delete_load_balancer <- function(LoadBalancerName) {
  op <- new_operation(
    name = "DeleteLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$delete_load_balancer_input(LoadBalancerName = LoadBalancerName)
  output <- .elb$delete_load_balancer_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$delete_load_balancer <- elb_delete_load_balancer

#' Deletes the specified listeners from the specified load balancer
#'
#' @description
#' Deletes the specified listeners from the specified load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_delete_load_balancer_listeners/](https://www.paws-r-sdk.com/docs/elb_delete_load_balancer_listeners/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param LoadBalancerPorts &#91;required&#93; The client port numbers of the listeners.
#'
#' @keywords internal
#'
#' @rdname elb_delete_load_balancer_listeners
elb_delete_load_balancer_listeners <- function(LoadBalancerName, LoadBalancerPorts) {
  op <- new_operation(
    name = "DeleteLoadBalancerListeners",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$delete_load_balancer_listeners_input(LoadBalancerName = LoadBalancerName, LoadBalancerPorts = LoadBalancerPorts)
  output <- .elb$delete_load_balancer_listeners_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$delete_load_balancer_listeners <- elb_delete_load_balancer_listeners

#' Deletes the specified policy from the specified load balancer
#'
#' @description
#' Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_delete_load_balancer_policy/](https://www.paws-r-sdk.com/docs/elb_delete_load_balancer_policy/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param PolicyName &#91;required&#93; The name of the policy.
#'
#' @keywords internal
#'
#' @rdname elb_delete_load_balancer_policy
elb_delete_load_balancer_policy <- function(LoadBalancerName, PolicyName) {
  op <- new_operation(
    name = "DeleteLoadBalancerPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$delete_load_balancer_policy_input(LoadBalancerName = LoadBalancerName, PolicyName = PolicyName)
  output <- .elb$delete_load_balancer_policy_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$delete_load_balancer_policy <- elb_delete_load_balancer_policy

#' Deregisters the specified instances from the specified load balancer
#'
#' @description
#' Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_deregister_instances_from_load_balancer/](https://www.paws-r-sdk.com/docs/elb_deregister_instances_from_load_balancer/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Instances &#91;required&#93; The IDs of the instances.
#'
#' @keywords internal
#'
#' @rdname elb_deregister_instances_from_load_balancer
elb_deregister_instances_from_load_balancer <- function(LoadBalancerName, Instances) {
  op <- new_operation(
    name = "DeregisterInstancesFromLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$deregister_instances_from_load_balancer_input(LoadBalancerName = LoadBalancerName, Instances = Instances)
  output <- .elb$deregister_instances_from_load_balancer_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$deregister_instances_from_load_balancer <- elb_deregister_instances_from_load_balancer

#' Describes the current Elastic Load Balancing resource limits for your
#' AWS account
#'
#' @description
#' Describes the current Elastic Load Balancing resource limits for your AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_describe_account_limits/](https://www.paws-r-sdk.com/docs/elb_describe_account_limits/) for full documentation.
#'
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call.
#'
#' @keywords internal
#'
#' @rdname elb_describe_account_limits
elb_describe_account_limits <- function(Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeAccountLimits",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "PageSize", output_token = "NextMarker", result_key = "Limits"),
    stream_api = FALSE
  )
  input <- .elb$describe_account_limits_input(Marker = Marker, PageSize = PageSize)
  output <- .elb$describe_account_limits_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_account_limits <- elb_describe_account_limits

#' Describes the state of the specified instances with respect to the
#' specified load balancer
#'
#' @description
#' Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_describe_instance_health/](https://www.paws-r-sdk.com/docs/elb_describe_instance_health/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Instances The IDs of the instances.
#'
#' @keywords internal
#'
#' @rdname elb_describe_instance_health
elb_describe_instance_health <- function(LoadBalancerName, Instances = NULL) {
  op <- new_operation(
    name = "DescribeInstanceHealth",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$describe_instance_health_input(LoadBalancerName = LoadBalancerName, Instances = Instances)
  output <- .elb$describe_instance_health_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_instance_health <- elb_describe_instance_health

#' Describes the attributes for the specified load balancer
#'
#' @description
#' Describes the attributes for the specified load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_describe_load_balancer_attributes/](https://www.paws-r-sdk.com/docs/elb_describe_load_balancer_attributes/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#'
#' @keywords internal
#'
#' @rdname elb_describe_load_balancer_attributes
elb_describe_load_balancer_attributes <- function(LoadBalancerName) {
  op <- new_operation(
    name = "DescribeLoadBalancerAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$describe_load_balancer_attributes_input(LoadBalancerName = LoadBalancerName)
  output <- .elb$describe_load_balancer_attributes_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_load_balancer_attributes <- elb_describe_load_balancer_attributes

#' Describes the specified policies
#'
#' @description
#' Describes the specified policies.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_describe_load_balancer_policies/](https://www.paws-r-sdk.com/docs/elb_describe_load_balancer_policies/) for full documentation.
#'
#' @param LoadBalancerName The name of the load balancer.
#' @param PolicyNames The names of the policies.
#'
#' @keywords internal
#'
#' @rdname elb_describe_load_balancer_policies
elb_describe_load_balancer_policies <- function(LoadBalancerName = NULL, PolicyNames = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancerPolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$describe_load_balancer_policies_input(LoadBalancerName = LoadBalancerName, PolicyNames = PolicyNames)
  output <- .elb$describe_load_balancer_policies_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_load_balancer_policies <- elb_describe_load_balancer_policies

#' Describes the specified load balancer policy types or all load balancer
#' policy types
#'
#' @description
#' Describes the specified load balancer policy types or all load balancer policy types.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_describe_load_balancer_policy_types/](https://www.paws-r-sdk.com/docs/elb_describe_load_balancer_policy_types/) for full documentation.
#'
#' @param PolicyTypeNames The names of the policy types. If no names are specified, describes all
#' policy types defined by Elastic Load Balancing.
#'
#' @keywords internal
#'
#' @rdname elb_describe_load_balancer_policy_types
elb_describe_load_balancer_policy_types <- function(PolicyTypeNames = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancerPolicyTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$describe_load_balancer_policy_types_input(PolicyTypeNames = PolicyTypeNames)
  output <- .elb$describe_load_balancer_policy_types_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_load_balancer_policy_types <- elb_describe_load_balancer_policy_types

#' Describes the specified the load balancers
#'
#' @description
#' Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_describe_load_balancers/](https://www.paws-r-sdk.com/docs/elb_describe_load_balancers/) for full documentation.
#'
#' @param LoadBalancerNames The names of the load balancers.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call (a number from 1
#' to 400). The default is 400.
#'
#' @keywords internal
#'
#' @rdname elb_describe_load_balancers
elb_describe_load_balancers <- function(LoadBalancerNames = NULL, Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", output_token = "NextMarker", result_key = "LoadBalancerDescriptions", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .elb$describe_load_balancers_input(LoadBalancerNames = LoadBalancerNames, Marker = Marker, PageSize = PageSize)
  output <- .elb$describe_load_balancers_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_load_balancers <- elb_describe_load_balancers

#' Describes the tags associated with the specified load balancers
#'
#' @description
#' Describes the tags associated with the specified load balancers.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_describe_tags/](https://www.paws-r-sdk.com/docs/elb_describe_tags/) for full documentation.
#'
#' @param LoadBalancerNames &#91;required&#93; The names of the load balancers.
#'
#' @keywords internal
#'
#' @rdname elb_describe_tags
elb_describe_tags <- function(LoadBalancerNames) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$describe_tags_input(LoadBalancerNames = LoadBalancerNames)
  output <- .elb$describe_tags_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_tags <- elb_describe_tags

#' Removes the specified subnets from the set of configured subnets for the
#' load balancer
#'
#' @description
#' Removes the specified subnets from the set of configured subnets for the load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_detach_load_balancer_from_subnets/](https://www.paws-r-sdk.com/docs/elb_detach_load_balancer_from_subnets/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Subnets &#91;required&#93; The IDs of the subnets.
#'
#' @keywords internal
#'
#' @rdname elb_detach_load_balancer_from_subnets
elb_detach_load_balancer_from_subnets <- function(LoadBalancerName, Subnets) {
  op <- new_operation(
    name = "DetachLoadBalancerFromSubnets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$detach_load_balancer_from_subnets_input(LoadBalancerName = LoadBalancerName, Subnets = Subnets)
  output <- .elb$detach_load_balancer_from_subnets_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$detach_load_balancer_from_subnets <- elb_detach_load_balancer_from_subnets

#' Removes the specified Availability Zones from the set of Availability
#' Zones for the specified load balancer in EC2-Classic or a default VPC
#'
#' @description
#' Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_disable_availability_zones_for_load_balancer/](https://www.paws-r-sdk.com/docs/elb_disable_availability_zones_for_load_balancer/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param AvailabilityZones &#91;required&#93; The Availability Zones.
#'
#' @keywords internal
#'
#' @rdname elb_disable_availability_zones_for_load_balancer
elb_disable_availability_zones_for_load_balancer <- function(LoadBalancerName, AvailabilityZones) {
  op <- new_operation(
    name = "DisableAvailabilityZonesForLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$disable_availability_zones_for_load_balancer_input(LoadBalancerName = LoadBalancerName, AvailabilityZones = AvailabilityZones)
  output <- .elb$disable_availability_zones_for_load_balancer_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$disable_availability_zones_for_load_balancer <- elb_disable_availability_zones_for_load_balancer

#' Adds the specified Availability Zones to the set of Availability Zones
#' for the specified load balancer in EC2-Classic or a default VPC
#'
#' @description
#' Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_enable_availability_zones_for_load_balancer/](https://www.paws-r-sdk.com/docs/elb_enable_availability_zones_for_load_balancer/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param AvailabilityZones &#91;required&#93; The Availability Zones. These must be in the same region as the load
#' balancer.
#'
#' @keywords internal
#'
#' @rdname elb_enable_availability_zones_for_load_balancer
elb_enable_availability_zones_for_load_balancer <- function(LoadBalancerName, AvailabilityZones) {
  op <- new_operation(
    name = "EnableAvailabilityZonesForLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$enable_availability_zones_for_load_balancer_input(LoadBalancerName = LoadBalancerName, AvailabilityZones = AvailabilityZones)
  output <- .elb$enable_availability_zones_for_load_balancer_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$enable_availability_zones_for_load_balancer <- elb_enable_availability_zones_for_load_balancer

#' Modifies the attributes of the specified load balancer
#'
#' @description
#' Modifies the attributes of the specified load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_modify_load_balancer_attributes/](https://www.paws-r-sdk.com/docs/elb_modify_load_balancer_attributes/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param LoadBalancerAttributes &#91;required&#93; The attributes for the load balancer.
#'
#' @keywords internal
#'
#' @rdname elb_modify_load_balancer_attributes
elb_modify_load_balancer_attributes <- function(LoadBalancerName, LoadBalancerAttributes) {
  op <- new_operation(
    name = "ModifyLoadBalancerAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$modify_load_balancer_attributes_input(LoadBalancerName = LoadBalancerName, LoadBalancerAttributes = LoadBalancerAttributes)
  output <- .elb$modify_load_balancer_attributes_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$modify_load_balancer_attributes <- elb_modify_load_balancer_attributes

#' Adds the specified instances to the specified load balancer
#'
#' @description
#' Adds the specified instances to the specified load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_register_instances_with_load_balancer/](https://www.paws-r-sdk.com/docs/elb_register_instances_with_load_balancer/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Instances &#91;required&#93; The IDs of the instances.
#'
#' @keywords internal
#'
#' @rdname elb_register_instances_with_load_balancer
elb_register_instances_with_load_balancer <- function(LoadBalancerName, Instances) {
  op <- new_operation(
    name = "RegisterInstancesWithLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$register_instances_with_load_balancer_input(LoadBalancerName = LoadBalancerName, Instances = Instances)
  output <- .elb$register_instances_with_load_balancer_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$register_instances_with_load_balancer <- elb_register_instances_with_load_balancer

#' Removes one or more tags from the specified load balancer
#'
#' @description
#' Removes one or more tags from the specified load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_remove_tags/](https://www.paws-r-sdk.com/docs/elb_remove_tags/) for full documentation.
#'
#' @param LoadBalancerNames &#91;required&#93; The name of the load balancer. You can specify a maximum of one load
#' balancer name.
#' @param Tags &#91;required&#93; The list of tag keys to remove.
#'
#' @keywords internal
#'
#' @rdname elb_remove_tags
elb_remove_tags <- function(LoadBalancerNames, Tags) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$remove_tags_input(LoadBalancerNames = LoadBalancerNames, Tags = Tags)
  output <- .elb$remove_tags_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$remove_tags <- elb_remove_tags

#' Sets the certificate that terminates the specified listener's SSL
#' connections
#'
#' @description
#' Sets the certificate that terminates the specified listener's SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_set_load_balancer_listener_ssl_certificate/](https://www.paws-r-sdk.com/docs/elb_set_load_balancer_listener_ssl_certificate/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param LoadBalancerPort &#91;required&#93; The port that uses the specified SSL certificate.
#' @param SSLCertificateId &#91;required&#93; The Amazon Resource Name (ARN) of the SSL certificate.
#'
#' @keywords internal
#'
#' @rdname elb_set_load_balancer_listener_ssl_certificate
elb_set_load_balancer_listener_ssl_certificate <- function(LoadBalancerName, LoadBalancerPort, SSLCertificateId) {
  op <- new_operation(
    name = "SetLoadBalancerListenerSSLCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$set_load_balancer_listener_ssl_certificate_input(LoadBalancerName = LoadBalancerName, LoadBalancerPort = LoadBalancerPort, SSLCertificateId = SSLCertificateId)
  output <- .elb$set_load_balancer_listener_ssl_certificate_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$set_load_balancer_listener_ssl_certificate <- elb_set_load_balancer_listener_ssl_certificate

#' Replaces the set of policies associated with the specified port on which
#' the EC2 instance is listening with a new set of policies
#'
#' @description
#' Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies. At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_set_load_balancer_policies_for_backend_server/](https://www.paws-r-sdk.com/docs/elb_set_load_balancer_policies_for_backend_server/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param InstancePort &#91;required&#93; The port number associated with the EC2 instance.
#' @param PolicyNames &#91;required&#93; The names of the policies. If the list is empty, then all current
#' polices are removed from the EC2 instance.
#'
#' @keywords internal
#'
#' @rdname elb_set_load_balancer_policies_for_backend_server
elb_set_load_balancer_policies_for_backend_server <- function(LoadBalancerName, InstancePort, PolicyNames) {
  op <- new_operation(
    name = "SetLoadBalancerPoliciesForBackendServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$set_load_balancer_policies_for_backend_server_input(LoadBalancerName = LoadBalancerName, InstancePort = InstancePort, PolicyNames = PolicyNames)
  output <- .elb$set_load_balancer_policies_for_backend_server_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$set_load_balancer_policies_for_backend_server <- elb_set_load_balancer_policies_for_backend_server

#' Replaces the current set of policies for the specified load balancer
#' port with the specified set of policies
#'
#' @description
#' Replaces the current set of policies for the specified load balancer port with the specified set of policies.
#'
#' See [https://www.paws-r-sdk.com/docs/elb_set_load_balancer_policies_of_listener/](https://www.paws-r-sdk.com/docs/elb_set_load_balancer_policies_of_listener/) for full documentation.
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param LoadBalancerPort &#91;required&#93; The external port of the load balancer.
#' @param PolicyNames &#91;required&#93; The names of the policies. This list must include all policies to be
#' enabled. If you omit a policy that is currently enabled, it is disabled.
#' If the list is empty, all current policies are disabled.
#'
#' @keywords internal
#'
#' @rdname elb_set_load_balancer_policies_of_listener
elb_set_load_balancer_policies_of_listener <- function(LoadBalancerName, LoadBalancerPort, PolicyNames) {
  op <- new_operation(
    name = "SetLoadBalancerPoliciesOfListener",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elb$set_load_balancer_policies_of_listener_input(LoadBalancerName = LoadBalancerName, LoadBalancerPort = LoadBalancerPort, PolicyNames = PolicyNames)
  output <- .elb$set_load_balancer_policies_of_listener_output()
  config <- get_config()
  svc <- .elb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$set_load_balancer_policies_of_listener <- elb_set_load_balancer_policies_of_listener
