% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_resolver_dnssec_configs}
\alias{route53resolver_list_resolver_dnssec_configs}
\title{Lists the configurations for DNSSEC validation that are associated with
the current Amazon Web Services account}
\usage{
route53resolver_list_resolver_dnssec_configs(
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL
)
}
\arguments{
\item{MaxResults}{\emph{Optional}: An integer that specifies the maximum number of DNSSEC
configuration results that you want Amazon Route 53 to return. If you
don't specify a value for \code{MaxResults}, Route 53 returns up to 100
configuration per page.}

\item{NextToken}{(Optional) If the current Amazon Web Services account has more than
\code{MaxResults} DNSSEC configurations, use \code{NextToken} to get the second
and subsequent pages of results.

For the first
\code{\link[=route53resolver_list_resolver_dnssec_configs]{list_resolver_dnssec_configs}}
request, omit this value.

For the second and subsequent requests, get the value of \code{NextToken}
from the previous response and specify that value for \code{NextToken} in the
request.}

\item{Filters}{An optional specification to return a subset of objects.}
}
\description{
Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_dnssec_configs/} for full documentation.
}
\keyword{internal}
