% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_create_tls_inspection_configuration}
\alias{networkfirewall_create_tls_inspection_configuration}
\title{Creates an Network Firewall TLS inspection configuration}
\usage{
networkfirewall_create_tls_inspection_configuration(
  TLSInspectionConfigurationName,
  TLSInspectionConfiguration,
  Description = NULL,
  Tags = NULL,
  EncryptionConfiguration = NULL
)
}
\arguments{
\item{TLSInspectionConfigurationName}{[required] The descriptive name of the TLS inspection configuration. You can't
change the name of a TLS inspection configuration after you create it.}

\item{TLSInspectionConfiguration}{[required] The object that defines a TLS inspection configuration. This, along with
TLSInspectionConfigurationResponse, define the TLS inspection
configuration. You can retrieve all objects for a TLS inspection
configuration by calling
\code{\link[=networkfirewall_describe_tls_inspection_configuration]{describe_tls_inspection_configuration}}.

Network Firewall uses a TLS inspection configuration to decrypt traffic.
Network Firewall re-encrypts the traffic before sending it to its
destination.

To use a TLS inspection configuration, you add it to a new Network
Firewall firewall policy, then you apply the firewall policy to a
firewall. Network Firewall acts as a proxy service to decrypt and
inspect the traffic traveling through your firewalls. You can reference
a TLS inspection configuration from more than one firewall policy, and
you can use a firewall policy in more than one firewall. For more
information about using TLS inspection configurations, see \href{https://docs.aws.amazon.com/network-firewall/latest/developerguide/}{Inspecting SSL/TLS traffic with TLS inspection configurations}
in the \emph{Network Firewall Developer Guide}.}

\item{Description}{A description of the TLS inspection configuration.}

\item{Tags}{The key:value pairs to associate with the resource.}

\item{EncryptionConfiguration}{}
}
\description{
Creates an Network Firewall TLS inspection configuration. A TLS inspection configuration contains Certificate Manager certificate associations between and the scope configurations that Network Firewall uses to decrypt and re-encrypt traffic traveling through your firewall.

See \url{https://www.paws-r-sdk.com/docs/networkfirewall_create_tls_inspection_configuration/} for full documentation.
}
\keyword{internal}
