% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_describe_direct_connect_gateway_associations}
\alias{directconnect_describe_direct_connect_gateway_associations}
\title{Lists the associations between your Direct Connect gateways and virtual
private gateways and transit gateways}
\usage{
directconnect_describe_direct_connect_gateway_associations(
  associationId = NULL,
  associatedGatewayId = NULL,
  directConnectGatewayId = NULL,
  maxResults = NULL,
  nextToken = NULL,
  virtualGatewayId = NULL
)
}
\arguments{
\item{associationId}{The ID of the Direct Connect gateway association.}

\item{associatedGatewayId}{The ID of the associated gateway.}

\item{directConnectGatewayId}{The ID of the Direct Connect gateway.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.

If \code{MaxResults} is given a value larger than 100, only 100 results are
returned.}

\item{nextToken}{The token provided in the previous call to retrieve the next page.}

\item{virtualGatewayId}{The ID of the virtual private gateway or transit gateway.}
}
\description{
Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:

See \url{https://paws-r.github.io/docs/directconnect/describe_direct_connect_gateway_associations.html} for full documentation.
}
\keyword{internal}
