% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_create_public_dns_namespace}
\alias{servicediscovery_create_public_dns_namespace}
\title{Creates a public namespace based on DNS, which will be visible on the
internet}
\usage{
servicediscovery_create_public_dns_namespace(Name, CreatorRequestId,
  Description)
}
\arguments{
\item{Name}{[required] The name that you want to assign to this namespace.}

\item{CreatorRequestId}{A unique string that identifies the request and that allows failed
\code{CreatePublicDnsNamespace} requests to be retried without the risk of
executing the operation twice. \code{CreatorRequestId} can be any unique
string, for example, a date/time stamp.}

\item{Description}{A description for the namespace.}
}
\description{
Creates a public namespace based on DNS, which will be visible on the
internet. The namespace defines your service naming scheme. For example,
if you name your namespace \code{example.com} and name your service
\code{backend}, the resulting DNS name for the service will be
\code{backend.example.com}. For the current limit on the number of namespaces
that you can create using the same AWS account, see \href{http://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html}{AWS Cloud Map Limits}
in the \emph{AWS Cloud Map Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_public_dns_namespace(
  Name = "string",
  CreatorRequestId = "string",
  Description = "string"
)
}
}

\keyword{internal}
