% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_resource_record_sets}
\alias{route53_list_resource_record_sets}
\title{Lists the resource record sets in a specified hosted zone}
\usage{
route53_list_resource_record_sets(HostedZoneId, StartRecordName,
  StartRecordType, StartRecordIdentifier, MaxItems)
}
\arguments{
\item{HostedZoneId}{[required] The ID of the hosted zone that contains the resource record sets that
you want to list.}

\item{StartRecordName}{The first name in the lexicographic ordering of resource record sets
that you want to list. If the specified record name doesn't exist, the
results begin with the first resource record set that has a name greater
than the value of \code{name}.}

\item{StartRecordType}{The type of resource record set to begin the record listing from.

Valid values for basic resource record sets: \code{A} | \code{AAAA} | \code{CAA} |
\code{CNAME} | \code{MX} | \code{NAPTR} | \code{NS} | \code{PTR} | \code{SOA} | \code{SPF} | \code{SRV} | \code{TXT}

Values for weighted, latency, geolocation, and failover resource record
sets: \code{A} | \code{AAAA} | \code{CAA} | \code{CNAME} | \code{MX} | \code{NAPTR} | \code{PTR} | \code{SPF} |
\code{SRV} | \code{TXT}

Values for alias resource record sets:
\itemize{
\item \strong{API Gateway custom regional API or edge-optimized API}: A
\item \strong{CloudFront distribution}: A or AAAA
\item \strong{Elastic Beanstalk environment that has a regionalized subdomain}:
A
\item \strong{Elastic Load Balancing load balancer}: A | AAAA
\item \strong{S3 bucket}: A
\item \strong{VPC interface VPC endpoint}: A
\item \strong{Another resource record set in this hosted zone:} The type of the
resource record set that the alias references.
}

Constraint: Specifying \code{type} without specifying \code{name} returns an
\code{InvalidInput} error.}

\item{StartRecordIdentifier}{\emph{Resource record sets that have a routing policy other than simple:} If
results were truncated for a given DNS name and type, specify the value
of \code{NextRecordIdentifier} from the previous response to get the next
resource record set that has the current DNS name and type.}

\item{MaxItems}{(Optional) The maximum number of resource records sets to include in the
response body for this request. If the response includes more than
\code{maxitems} resource record sets, the value of the \code{IsTruncated} element
in the response is \code{true}, and the values of the \code{NextRecordName} and
\code{NextRecordType} elements in the response identify the first resource
record set in the next group of \code{maxitems} resource record sets.}
}
\value{
A list with the following syntax:\preformatted{list(
  ResourceRecordSets = list(
    list(
      Name = "string",
      Type = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
      SetIdentifier = "string",
      Weight = 123,
      Region = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"ca-central-1"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"cn-north-1"|"cn-northwest-1"|"ap-east-1"|"me-south-1"|"ap-south-1"|"af-south-1"|"eu-south-1",
      GeoLocation = list(
        ContinentCode = "string",
        CountryCode = "string",
        SubdivisionCode = "string"
      ),
      Failover = "PRIMARY"|"SECONDARY",
      MultiValueAnswer = TRUE|FALSE,
      TTL = 123,
      ResourceRecords = list(
        list(
          Value = "string"
        )
      ),
      AliasTarget = list(
        HostedZoneId = "string",
        DNSName = "string",
        EvaluateTargetHealth = TRUE|FALSE
      ),
      HealthCheckId = "string",
      TrafficPolicyInstanceId = "string"
    )
  ),
  IsTruncated = TRUE|FALSE,
  NextRecordName = "string",
  NextRecordType = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
  NextRecordIdentifier = "string",
  MaxItems = "string"
)
}
}
\description{
Lists the resource record sets in a specified hosted zone.

\code{\link[=route53_list_resource_record_sets]{list_resource_record_sets}} returns
up to 100 resource record sets at a time in ASCII order, beginning at a
position specified by the \code{name} and \code{type} elements.

\strong{Sort order}

\code{\link[=route53_list_resource_record_sets]{list_resource_record_sets}} sorts
results first by DNS name with the labels reversed, for example:

\code{com.example.www.}

Note the trailing dot, which can change the sort order when the record
name contains characters that appear before \code{.} (decimal 46) in the
ASCII table. These characters include the following:
\verb{! \\" # $ \% & \\' ( ) * + , -}

When multiple records have the same DNS name,
\code{\link[=route53_list_resource_record_sets]{list_resource_record_sets}} sorts
results by the record type.

\strong{Specifying where to start listing records}

You can use the name and type elements to specify the resource record
set that the list begins with:
\subsection{If you do not specify Name or Type}{

The results begin with the first resource record set that the hosted
zone contains.
}

\subsection{If you specify Name but not Type}{

The results begin with the first resource record set in the list whose
name is greater than or equal to \code{Name}.
}

\subsection{If you specify Type but not Name}{

Amazon Route 53 returns the \code{InvalidInput} error.
}

\subsection{If you specify both Name and Type}{

The results begin with the first resource record set in the list whose
name is greater than or equal to \code{Name}, and whose type is greater than
or equal to \code{Type}.

\strong{Resource record sets that are PENDING}

This action returns the most current version of the records. This
includes records that are \code{PENDING}, and that are not yet available on
all Route 53 DNS servers.

\strong{Changing resource record sets}

To ensure that you get an accurate listing of the resource record sets
for a hosted zone at a point in time, do not submit a
\code{\link[=route53_change_resource_record_sets]{change_resource_record_sets}}
request while you're paging through the results of a
\code{\link[=route53_list_resource_record_sets]{list_resource_record_sets}}
request. If you do, some pages may display results without the latest
changes while other pages display results with the latest changes.

\strong{Displaying the next page of results}

If a \code{\link[=route53_list_resource_record_sets]{list_resource_record_sets}}
command returns more than one page of results, the value of
\code{IsTruncated} is \code{true}. To display the next page of results, get the
values of \code{NextRecordName}, \code{NextRecordType}, and \code{NextRecordIdentifier}
(if any) from the response. Then submit another
\code{\link[=route53_list_resource_record_sets]{list_resource_record_sets}}
request, and specify those values for \code{StartRecordName},
\code{StartRecordType}, and \code{StartRecordIdentifier}.
}
}
\section{Request syntax}{
\preformatted{svc$list_resource_record_sets(
  HostedZoneId = "string",
  StartRecordName = "string",
  StartRecordType = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
  StartRecordIdentifier = "string",
  MaxItems = "string"
)
}
}

\keyword{internal}
