% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_delete_route}
\alias{appmesh_delete_route}
\title{Deletes an existing route}
\usage{
appmesh_delete_route(meshName, meshOwner, routeName, virtualRouterName)
}
\arguments{
\item{meshName}{[required] The name of the service mesh to delete the route in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it's the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{routeName}{[required] The name of the route to delete.}

\item{virtualRouterName}{[required] The name of the virtual router to delete the route in.}
}
\description{
Deletes an existing route.
}
\section{Request syntax}{
\preformatted{svc$delete_route(
  meshName = "string",
  meshOwner = "string",
  routeName = "string",
  virtualRouterName = "string"
)
}
}

\keyword{internal}
